/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.ReleaseGroupIndexField;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.ReleaseGroupQueryParser;
import org.musicbrainz.search.servlet.ResourceType;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd1.ReleaseGroupMmd1XmlWriter;
import org.musicbrainz.search.servlet.mmd2.ReleaseGroupWriter;

public class ReleaseGroupSearch
extends AbstractSearchServer {
    protected void setupDefaultFields() {
        this.defaultFields = new ArrayList();
        this.defaultFields.add(ReleaseGroupIndexField.RELEASEGROUP.getName());
    }

    public ReleaseGroupSearch() throws Exception {
        this.resultsWriter = new ReleaseGroupWriter();
        this.mmd1Writer = new ReleaseGroupMmd1XmlWriter();
        this.setupDefaultFields();
        this.analyzer = DatabaseIndex.getAnalyzer(ReleaseGroupIndexField.class);
    }

    public ReleaseGroupSearch(SearcherManager searcherManager) throws Exception {
        this();
        this.searcherManager = searcherManager;
        this.setLastServerUpdatedDate();
        this.resultsWriter.setLastServerUpdatedDate(this.getServerLastUpdatedDate());
    }

    public QueryParser getParser() {
        return new ReleaseGroupQueryParser(this.defaultFields.toArray(new String[0]), this.analyzer);
    }

    protected String printExplainHeader(Document doc) throws IOException, ParseException {
        return doc.get(ReleaseGroupIndexField.RELEASEGROUP_ID.getName()) + ':' + doc.get(ReleaseGroupIndexField.RELEASE.getName()) + '\n';
    }

    protected Results processResults(IndexSearcher searcher, TopDocs topDocs, int offset) throws IOException {
        Results results = super.processResults(searcher, topDocs, offset);
        results.setResourceType(ResourceType.RELEASE_GROUP);
        return results;
    }
}

