/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.time.StopWatch;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.musicbrainz.search.LuceneVersion;
import org.musicbrainz.search.index.AnnotationIndex;
import org.musicbrainz.search.index.AreaIndex;
import org.musicbrainz.search.index.ArtistIndex;
import org.musicbrainz.search.index.CDStubIndex;
import org.musicbrainz.search.index.CommonTables;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.EditorIndex;
import org.musicbrainz.search.index.EventIndex;
import org.musicbrainz.search.index.FreeDBIndex;
import org.musicbrainz.search.index.IndexOptions;
import org.musicbrainz.search.index.InstrumentIndex;
import org.musicbrainz.search.index.LabelIndex;
import org.musicbrainz.search.index.OpenFileLimitCheck;
import org.musicbrainz.search.index.PlaceIndex;
import org.musicbrainz.search.index.RecordingIndex;
import org.musicbrainz.search.index.ReleaseGroupIndex;
import org.musicbrainz.search.index.ReleaseIndex;
import org.musicbrainz.search.index.ReplicationInformation;
import org.musicbrainz.search.index.SeriesIndex;
import org.musicbrainz.search.index.TagIndex;
import org.musicbrainz.search.index.ThreadedIndexWriter;
import org.musicbrainz.search.index.UrlIndex;
import org.musicbrainz.search.index.Utils;
import org.musicbrainz.search.index.WorkIndex;

public class IndexBuilder {
    private static final int MAX_THREADS_FOR_CONCURRENT_OPTIMIZATION = 1;

    public static void main(String[] args) throws SQLException, IOException, InterruptedException {
        ArrayList<String> selectedIndexes;
        IndexOptions options = new IndexOptions();
        CmdLineParser parser = new CmdLineParser(options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println("Couldn't parse command line parameters");
            parser.printUsage(System.out);
            System.exit(1);
        }
        if (options.isCheckFileLimit()) {
            OpenFileLimitCheck.checkOpenFileLimit();
            System.exit(0);
        }
        if (options.isHelp()) {
            parser.printUsage(System.out);
            System.exit(1);
        }
        if (options.isTest()) {
            System.out.println("Running in test mode.");
        }
        if ((selectedIndexes = options.selectedIndexes()).size() == 0 || selectedIndexes.size() == 1 && selectedIndexes.contains("")) {
            System.out.println("No indexes selected. Exiting.");
            System.exit(1);
        }
        Connection mainDbConn = null;
        System.out.println("Index Builder Started:" + Utils.formatCurrentTimeForOutput());
        if (options.selectedIndexes().size() > 1 || !options.buildIndex("freedb")) {
            try {
                Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e) {
                System.err.println("Couldn't load org.postgresql.Driver");
                System.exit(1);
            }
            mainDbConn = options.getMainDatabaseConnection();
        }
        DatabaseIndex[] indexes = new DatabaseIndex[]{new RecordingIndex(mainDbConn), new ReleaseIndex(mainDbConn), new WorkIndex(mainDbConn), new ArtistIndex(mainDbConn), new ReleaseGroupIndex(mainDbConn), new LabelIndex(mainDbConn), new AreaIndex(mainDbConn), new PlaceIndex(mainDbConn), new EventIndex(mainDbConn), new AnnotationIndex(mainDbConn), new UrlIndex(mainDbConn), new InstrumentIndex(mainDbConn), new SeriesIndex(mainDbConn), new EditorIndex(mainDbConn), new TagIndex(mainDbConn), new CDStubIndex(mainDbConn)};
        ArrayList<String> indexesToBeBuilt = new ArrayList<String>();
        for (DatabaseIndex index : indexes) {
            if (!options.buildIndex(index.getName())) continue;
            indexesToBeBuilt.add(index.getName());
        }
        ReplicationInformation initialReplicationInformation = null;
        if (indexesToBeBuilt.size() > 0) {
            initialReplicationInformation = indexes[0].readReplicationInformationFromDatabase();
        }
        CommonTables commonTables = new CommonTables(mainDbConn, indexesToBeBuilt);
        commonTables.createTemporaryTables(false);
        ExecutorService es = Executors.newFixedThreadPool(1);
        ExecutorCompletionService<Boolean> cs = new ExecutorCompletionService<Boolean>(es);
        for (DatabaseIndex index : indexes) {
            if (!options.buildIndex(index.getName())) {
                System.out.println("Skipping index: " + index.getName());
                continue;
            }
            IndexWriter indexWriter = IndexBuilder.createIndexWriter(index, options);
            int maxId = IndexBuilder.buildDatabaseIndex(indexWriter, index, options, initialReplicationInformation);
            cs.submit(new IndexWriterOptimizerAndClose(maxId, indexWriter, index, options));
        }
        if (options.buildIndex("freedb")) {
            File dumpFile = new File(options.getFreeDBDump());
            if (options.getFreeDBDump() != null && options.getFreeDBDump().length() != 0) {
                if (dumpFile.isFile()) {
                    IndexBuilder.buildFreeDBIndex(dumpFile, options);
                } else {
                    System.out.println("  Can't build FreeDB index: invalid file " + options.getFreeDBDump());
                }
            }
        }
        System.out.println("Waiting for any indexes to finish optimizing:" + Utils.formatCurrentTimeForOutput());
        for (int i = 0; i < indexesToBeBuilt.size(); ++i) {
            Future result = cs.take();
            try {
                if (((Boolean)result.get()).booleanValue()) continue;
                System.out.println("Optimize Failed");
                continue;
            }
            catch (ExecutionException ee) {
                System.out.println("Optimize Failed with unexpected exception");
            }
        }
        es.shutdown();
        if (mainDbConn != null) {
            mainDbConn.close();
        }
        System.out.println("Index Builder Finished:" + Utils.formatCurrentTimeForOutput());
    }

    private static IndexWriter createIndexWriter(DatabaseIndex index, IndexOptions options) throws IOException, SQLException {
        String path = options.getIndexesDir() + index.getFilename();
        FSDirectory fsDir = FSDirectory.open(new File(path), NoLockFactory.getNoLockFactory());
        IndexWriterConfig config = new IndexWriterConfig(LuceneVersion.LUCENE_VERSION, index.getAnalyzer());
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        config.setMaxBufferedDocs(options.getMaxBufferedDocs());
        if (index.getSimilarity() != null) {
            config.setSimilarity(index.getSimilarity());
        }
        ThreadedIndexWriter indexWriter = new ThreadedIndexWriter(fsDir, config, Runtime.getRuntime().availableProcessors(), options.getDatabaseChunkSize());
        return indexWriter;
    }

    private static int buildDatabaseIndex(IndexWriter indexWriter, DatabaseIndex index, IndexOptions options, ReplicationInformation initialReplicationInformation) throws IOException, SQLException {
        StopWatch clock = new StopWatch();
        clock.start();
        System.out.println(index.getName() + ":Started at " + Utils.formatCurrentTimeForOutput());
        index.init(indexWriter, false);
        index.addMetaInformation(indexWriter, initialReplicationInformation);
        int maxId = index.getMaxId();
        if (maxId > 0) {
            if (options.isTest() && options.getTestIndexSize() < maxId) {
                maxId = options.getTestIndexSize();
            }
            for (int j = 0; j <= maxId; j += options.getDatabaseChunkSize()) {
                int k = Math.min(j + options.getDatabaseChunkSize() - 1, maxId);
                System.out.print(index.getName() + ":Indexing " + j + "..." + k + " / " + maxId + " (" + 100 * k / maxId + "%)\r");
                index.indexData(indexWriter, j, k);
            }
        }
        index.destroy();
        clock.stop();
        System.out.println("\n" + index.getName() + ":Finished:" + Utils.formatClock(clock));
        return maxId;
    }

    private static void buildFreeDBIndex(File dumpFile, IndexOptions options) throws IOException {
        FreeDBIndex index = new FreeDBIndex();
        index.setDumpFile(dumpFile);
        StopWatch clock = new StopWatch();
        clock.start();
        System.out.println(index.getName() + ":Started at " + Utils.formatCurrentTimeForOutput());
        IndexWriterConfig config = new IndexWriterConfig(LuceneVersion.LUCENE_VERSION, index.getAnalyzer());
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        config.setMaxBufferedDocs(options.getMaxBufferedDocs());
        String path = options.getIndexesDir() + index.getFilename();
        System.out.println("Building index: " + path);
        IndexWriter indexWriter = new IndexWriter(FSDirectory.open(new File(path)), config);
        index.addMetaInformation(indexWriter);
        index.indexData(indexWriter);
        indexWriter.close();
        System.out.println(index.getName() + ":Finished:" + Utils.formatClock(clock));
    }

    static class IndexWriterOptimizerAndClose
    implements Callable<Boolean> {
        private int maxId;
        private IndexWriter indexWriter;
        private DatabaseIndex index;
        private IndexOptions options;

        public IndexWriterOptimizerAndClose(int maxId, IndexWriter indexWriter, DatabaseIndex index, IndexOptions options) {
            this.maxId = maxId;
            this.indexWriter = indexWriter;
            this.index = index;
            this.options = options;
        }

        @Override
        public Boolean call() {
            DirectoryReader reader = null;
            try {
                StopWatch clock = new StopWatch();
                clock.start();
                String path = this.options.getIndexesDir() + this.index.getFilename();
                System.out.println(this.index.getName() + ":Started Optimization at " + Utils.formatCurrentTimeForOutput());
                this.indexWriter.close();
                clock.stop();
                int dbRows = this.index.getNoOfRows(this.maxId);
                reader = DirectoryReader.open(FSDirectory.open(new File(path)));
                System.out.println(this.index.getName() + ":" + dbRows + " db rows:" + (((IndexReader)reader).maxDoc() - 1) + " lucene docs");
                System.out.println(this.index.getName() + ":Finished Optimization:" + Utils.formatClock(clock));
                return true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    this.indexWriter.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return false;
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                try {
                    this.indexWriter.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return false;
            }
        }
    }
}

