/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Event;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Relation;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.helper.AliasHelper;
import org.musicbrainz.search.helper.LinkedAreasHelper;
import org.musicbrainz.search.helper.LinkedArtistsHelper;
import org.musicbrainz.search.helper.LinkedPlacesHelper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.EventIndexField;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.Utils;

public class EventIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "event";

    public EventIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public EventIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public IndexField getIdentifierField() {
        return EventIndexField.ID;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(EventIndexField.class);
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM event");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM event WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("EVENT", "SELECT  e.id, e.gid, e.name, e.time, et.name as type,   e.begin_date_year, e.begin_date_month, e.begin_date_day,   e.end_date_year, e.end_date_month, e.end_date_day, e.ended, e.comment  FROM event e  LEFT JOIN event_type et ON e.type = et.id  WHERE e.id BETWEEN ? AND ?  ORDER BY e.id");
        this.addPreparedStatement("ALIASES", AliasHelper.constructAliasQuery(INDEX_NAME));
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("event_tag", INDEX_NAME));
        this.addPreparedStatement("ARTISTS", LinkedArtistsHelper.constructRelationQuery("l_artist_event", INDEX_NAME, true));
        this.addPreparedStatement("PLACES", LinkedPlacesHelper.constructRelationQuery("l_event_place", INDEX_NAME, false));
        this.addPreparedStatement("AREAS", LinkedAreasHelper.constructRelationQuery("l_area_event", INDEX_NAME, true));
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, Set<Alias>> aliases = AliasHelper.completeFromDbResults(min, max, this.getPreparedStatement("ALIASES"));
        ArrayListMultimap<Integer, Relation> artistRelations = LinkedArtistsHelper.loadRelations(min, max, this.getPreparedStatement("ARTISTS"));
        ArrayListMultimap<Integer, Relation> placeRelations = LinkedPlacesHelper.loadRelations(min, max, this.getPreparedStatement("PLACES"));
        ArrayListMultimap<Integer, Relation> areaRelations = LinkedAreasHelper.loadRelations(min, max, this.getPreparedStatement("AREAS"));
        Map<Integer, List<Tag>> tags = TagHelper.loadTags(min, max, this.getPreparedStatement("TAGS"), INDEX_NAME);
        PreparedStatement st = this.getPreparedStatement("EVENT");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, artistRelations, placeRelations, areaRelations, tags, aliases));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, ArrayListMultimap<Integer, Relation> artistRelations, ArrayListMultimap<Integer, Relation> placeRelations, ArrayListMultimap<Integer, Relation> areaRelations, Map<Integer, List<Tag>> tags, Map<Integer, Set<Alias>> aliases) throws SQLException {
        String time;
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Event event = of.createEvent();
        int eventId = rs.getInt("id");
        doc.addField((IndexField)EventIndexField.ID, eventId);
        String guid = rs.getString("gid");
        doc.addField((IndexField)EventIndexField.EVENT_ID, guid);
        event.setId(guid);
        String name = rs.getString("name");
        doc.addField((IndexField)EventIndexField.EVENT, name);
        event.setName(name);
        String comment = rs.getString("comment");
        if (!Strings.isNullOrEmpty(comment)) {
            doc.addField((IndexField)EventIndexField.COMMENT, comment);
            event.setDisambiguation(comment);
        }
        String type = rs.getString("type");
        doc.addFieldOrUnknown(EventIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            event.setType(type);
        }
        if (!Strings.isNullOrEmpty(time = rs.getString("time"))) {
            event.setTime(time);
        }
        boolean ended = rs.getBoolean("ended");
        doc.addFieldOrUnknown(ArtistIndexField.ENDED, Boolean.toString(ended));
        String begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day"));
        doc.addNonEmptyField(ArtistIndexField.BEGIN, begin);
        String end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day"));
        doc.addNonEmptyField(ArtistIndexField.END, end);
        Event.LifeSpan lifespan = of.createEventLifeSpan();
        event.setLifeSpan(lifespan);
        if (!Strings.isNullOrEmpty(begin)) {
            lifespan.setBegin(begin);
        }
        if (!Strings.isNullOrEmpty(end)) {
            lifespan.setEnd(end);
        }
        if (artistRelations.containsKey(eventId)) {
            event.getRelationList().add(LinkedArtistsHelper.addToDocAndConstructList(of, doc, artistRelations.get((Object)eventId), EventIndexField.ARTIST_ID, EventIndexField.ARTIST));
        }
        if (placeRelations.containsKey(eventId)) {
            event.getRelationList().add(LinkedPlacesHelper.addToDocAndConstructList(of, doc, placeRelations.get((Object)eventId), EventIndexField.PLACE_ID, EventIndexField.PLACE));
        }
        if (areaRelations.containsKey(eventId)) {
            event.getRelationList().add(LinkedAreasHelper.addToDocAndConstructList(of, doc, areaRelations.get((Object)eventId), EventIndexField.AREA_ID, EventIndexField.AREA));
        }
        if (aliases.containsKey(eventId)) {
            event.setAliasList(AliasHelper.addAliasesToDocAndConstructAliasList(of, doc, aliases, eventId, EventIndexField.ALIAS));
        }
        if (tags.containsKey(eventId)) {
            event.setTagList(TagHelper.addTagsToDocAndConstructTagList(of, doc, tags, eventId, EventIndexField.TAG));
        }
        String store = MMDSerializer.serialize(event);
        doc.addField((IndexField)EventIndexField.EVENT_STORE, store);
        return doc.getLuceneDocument();
    }
}

