/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.MusicbrainzAnalyzer;
import org.musicbrainz.search.index.Index;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MetaIndexField;
import org.musicbrainz.search.index.ReplicationInformation;

public abstract class DatabaseIndex
implements Index {
    private static final String INDEX_SUFFIX = "_index";
    protected HashMap<String, PreparedStatement> preparedStatements;
    protected Connection dbConnection;

    @Override
    public String getFilename() {
        return this.getName() + INDEX_SUFFIX;
    }

    protected DatabaseIndex(Connection dbConnection) {
        this.preparedStatements = new HashMap();
        this.dbConnection = dbConnection;
    }

    protected DatabaseIndex() {
    }

    public static Analyzer getAnalyzer(Class indexFieldClass) {
        HashMap<String, Analyzer> fieldAnalyzers = new HashMap<String, Analyzer>();
        for (Object o : EnumSet.allOf(indexFieldClass)) {
            IndexField indexField = (IndexField)o;
            Analyzer analyzer = indexField.getAnalyzer();
            if (analyzer == null) continue;
            fieldAnalyzers.put(indexField.getName(), analyzer);
        }
        PerFieldAnalyzerWrapper wrapper = new PerFieldAnalyzerWrapper(new MusicbrainzAnalyzer(), fieldAnalyzers);
        return wrapper;
    }

    public ReplicationInformation readReplicationInformationFromIndex(IndexReader reader) throws IOException {
        ReplicationInformation info = new ReplicationInformation();
        IndexSearcher searcher = new IndexSearcher(reader);
        Term term = new Term(MetaIndexField.META.getName(), "1");
        TermQuery query = new TermQuery(term);
        TopDocs hits = searcher.search((Query)query, 10);
        if (hits.scoreDocs.length == 0) {
            throw new IllegalArgumentException("No matches in the index for the given Term.");
        }
        if (hits.scoreDocs.length > 1) {
            throw new IllegalArgumentException("Given Term matches more than 1 document in the index.");
        }
        int docId = hits.scoreDocs[0].doc;
        MbDocument doc = new MbDocument(searcher.doc(docId));
        info.replicationSequence = Integer.parseInt(doc.get(MetaIndexField.REPLICATION_SEQUENCE));
        info.schemaSequence = Integer.parseInt(doc.get(MetaIndexField.SCHEMA_SEQUENCE));
        String tmpStr = doc.get(MetaIndexField.LAST_CHANGE_SEQUENCE);
        info.changeSequence = tmpStr != null && !tmpStr.isEmpty() ? Integer.valueOf(Integer.parseInt(tmpStr)) : null;
        return info;
    }

    public ReplicationInformation readReplicationInformationFromDatabase() throws IOException {
        ReplicationInformation info = new ReplicationInformation();
        try {
            Statement st = this.dbConnection.createStatement();
            ResultSet rs = st.executeQuery("SELECT current_schema_sequence, current_replication_sequence FROM replication_control");
            rs.next();
            info.schemaSequence = rs.getInt("current_schema_sequence");
            info.replicationSequence = rs.getInt("current_replication_sequence");
            DatabaseMetaData meta = this.dbConnection.getMetaData();
            rs = meta.getTables(null, null, "dbmirror_pending", new String[]{"TABLE"});
            if (rs.first()) {
                rs = st.executeQuery("SELECT MAX(seqid) FROM dbmirror_pending");
                rs.first();
                info.changeSequence = rs.getInt(0);
            } else {
                info.changeSequence = null;
            }
        }
        catch (SQLException e) {
            System.err.println(this.getName() + ": Unable to get replication information");
        }
        return info;
    }

    @Override
    public void addMetaInformation(IndexWriter indexWriter) throws IOException {
        ReplicationInformation info = this.readReplicationInformationFromDatabase();
        this.addMetaInformation(indexWriter, info);
    }

    public void addMetaInformation(IndexWriter indexWriter, ReplicationInformation info) throws IOException {
        MbDocument doc = new MbDocument();
        doc.addField((IndexField)MetaIndexField.META, "1");
        doc.addNumericField((IndexField)MetaIndexField.LAST_UPDATED, new Date().getTime());
        doc.addField((IndexField)MetaIndexField.SCHEMA_SEQUENCE, info.schemaSequence);
        doc.addField((IndexField)MetaIndexField.REPLICATION_SEQUENCE, info.replicationSequence);
        if (info.changeSequence != null) {
            doc.addField((IndexField)MetaIndexField.LAST_CHANGE_SEQUENCE, info.changeSequence);
        }
        indexWriter.addDocument(doc.getLuceneDocument());
    }

    public void updateMetaInformation(IndexWriter indexWriter, ReplicationInformation info) throws IOException {
        Term term = new Term(MetaIndexField.META.getName(), "1");
        TermQuery query = new TermQuery(term);
        indexWriter.deleteDocuments((Query)query);
        this.addMetaInformation(indexWriter, info);
    }

    public PreparedStatement addPreparedStatement(String identifier, String SQL) throws SQLException {
        PreparedStatement st = this.dbConnection.prepareStatement(SQL);
        this.preparedStatements.put(identifier, st);
        return st;
    }

    public PreparedStatement getPreparedStatement(String identifier) {
        return this.preparedStatements.get(identifier);
    }

    public Connection getDbConnection() {
        return this.dbConnection;
    }

    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
    }

    public void destroy() throws SQLException {
        for (PreparedStatement st : this.preparedStatements.values()) {
            st.close();
        }
    }

    public abstract int getNoOfRows(int var1) throws SQLException;

    public abstract int getMaxId() throws SQLException;

    public abstract void indexData(IndexWriter var1, int var2, int var3) throws SQLException, IOException;

    public abstract IndexField getIdentifierField();

    @Override
    public Similarity getSimilarity() {
        return null;
    }
}

