/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.DocValuesFieldSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public final class NumericDocValuesFieldSource
extends DocValuesFieldSource {
    public NumericDocValuesFieldSource(String fieldName, boolean direct) {
        super(fieldName, direct);
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final DocValues.Source source = this.getSource(readerContext.reader(), DocValues.Type.FLOAT_64);
        final Bits liveDocs = readerContext.reader().getLiveDocs();
        switch (source.getType()) {
            case FIXED_INTS_8: 
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: 
            case VAR_INTS: {
                if (source.hasArray()) {
                    Object valuesArr = source.getArray();
                    if (valuesArr instanceof long[]) {
                        final long[] values = (long[])source.getArray();
                        return new DVLongValues(this, source, liveDocs){

                            @Override
                            public long longVal(int doc) {
                                return values[doc];
                            }
                        };
                    }
                    if (valuesArr instanceof int[]) {
                        final int[] values = (int[])source.getArray();
                        return new DVIntValues(this, source, liveDocs){

                            @Override
                            public int intVal(int doc) {
                                return values[doc];
                            }
                        };
                    }
                    if (valuesArr instanceof short[]) {
                        final short[] values = (short[])source.getArray();
                        return new DVIntValues(this, source, liveDocs){

                            @Override
                            public int intVal(int doc) {
                                return values[doc];
                            }

                            @Override
                            public Object objectVal(int doc) {
                                return this.shortVal(doc);
                            }
                        };
                    }
                    if (valuesArr instanceof byte[]) {
                        final byte[] values = (byte[])source.getArray();
                        return new DVIntValues(this, source, liveDocs){

                            @Override
                            public int intVal(int doc) {
                                return values[doc];
                            }

                            @Override
                            public Object objectVal(int doc) {
                                return this.byteVal(doc);
                            }
                        };
                    }
                }
                return new DVLongValues(this, source, liveDocs){

                    @Override
                    public Object objectVal(int doc) {
                        switch (source.getType()) {
                            case FIXED_INTS_8: {
                                return this.byteVal(doc);
                            }
                            case FIXED_INTS_16: {
                                return this.shortVal(doc);
                            }
                            case FIXED_INTS_32: {
                                return this.intVal(doc);
                            }
                            case FIXED_INTS_64: 
                            case VAR_INTS: {
                                return this.longVal(doc);
                            }
                        }
                        throw new AssertionError();
                    }
                };
            }
            case FLOAT_32: 
            case FLOAT_64: {
                if (source.hasArray()) {
                    Object valuesArr = source.getArray();
                    if (valuesArr instanceof float[]) {
                        final float[] values = (float[])valuesArr;
                        return new FloatDocValues(this){

                            @Override
                            public boolean exists(int doc) {
                                return liveDocs == null || liveDocs.get(doc);
                            }

                            @Override
                            public boolean bytesVal(int doc, BytesRef target) {
                                source.getBytes(doc, target);
                                return true;
                            }

                            @Override
                            public float floatVal(int doc) {
                                return values[doc];
                            }
                        };
                    }
                    if (valuesArr instanceof double[]) {
                        final double[] values = (double[])valuesArr;
                        return new DVDoubleValues(this, source, liveDocs){

                            @Override
                            public double doubleVal(int doc) {
                                return values[doc];
                            }
                        };
                    }
                }
                return new DVDoubleValues(this, source, liveDocs){

                    @Override
                    public Object objectVal(int doc) {
                        switch (source.getType()) {
                            case FLOAT_32: {
                                return Float.valueOf(this.floatVal(doc));
                            }
                            case FLOAT_64: {
                                return this.doubleVal(doc);
                            }
                        }
                        throw new AssertionError();
                    }
                };
            }
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " only works with numeric types, not " + (Object)((Object)source.getType()));
    }

    private static abstract class DVDoubleValues
    extends DoubleDocValues {
        private final Bits liveDocs;
        private final DocValues.Source source;

        public DVDoubleValues(ValueSource vs, DocValues.Source source, Bits liveDocs) {
            super(vs);
            this.liveDocs = liveDocs;
            this.source = source;
        }

        @Override
        public boolean exists(int doc) {
            return this.liveDocs == null || this.liveDocs.get(doc);
        }

        @Override
        public boolean bytesVal(int doc, BytesRef target) {
            this.source.getBytes(doc, target);
            return true;
        }

        @Override
        public double doubleVal(int doc) {
            return this.source.getFloat(doc);
        }
    }

    private static class DVLongValues
    extends LongDocValues {
        private final Bits liveDocs;
        private final DocValues.Source source;

        public DVLongValues(ValueSource vs, DocValues.Source source, Bits liveDocs) {
            super(vs);
            this.liveDocs = liveDocs;
            this.source = source;
        }

        @Override
        public boolean exists(int doc) {
            return this.liveDocs == null || this.liveDocs.get(doc);
        }

        @Override
        public boolean bytesVal(int doc, BytesRef target) {
            this.source.getBytes(doc, target);
            return true;
        }

        @Override
        public long longVal(int doc) {
            return this.source.getInt(doc);
        }
    }

    private static abstract class DVIntValues
    extends IntDocValues {
        private final Bits liveDocs;
        private final DocValues.Source source;

        public DVIntValues(ValueSource vs, DocValues.Source source, Bits liveDocs) {
            super(vs);
            this.liveDocs = liveDocs;
            this.source = source;
        }

        @Override
        public boolean exists(int doc) {
            return this.liveDocs == null || this.liveDocs.get(doc);
        }

        @Override
        public boolean bytesVal(int doc, BytesRef target) {
            this.source.getBytes(doc, target);
            return true;
        }

        @Override
        public int intVal(int doc) {
            return (int)this.source.getInt(doc);
        }
    }
}

