/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.collation.ICUCollationKeyFilter;
import org.apache.lucene.util.IOUtils;

@Deprecated
public class ICUCollationKeyFilterFactory
extends TokenFilterFactory
implements MultiTermAwareComponent,
ResourceLoaderAware {
    private Collator collator;

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String custom = (String)this.args.get("custom");
        String localeID = (String)this.args.get("locale");
        String strength = (String)this.args.get("strength");
        String decomposition = (String)this.args.get("decomposition");
        String alternate = (String)this.args.get("alternate");
        String caseLevel = (String)this.args.get("caseLevel");
        String caseFirst = (String)this.args.get("caseFirst");
        String numeric = (String)this.args.get("numeric");
        String variableTop = (String)this.args.get("variableTop");
        if (custom == null && localeID == null) {
            throw new IllegalArgumentException("Either custom or locale is required.");
        }
        if (custom != null && localeID != null) {
            throw new IllegalArgumentException("Cannot specify both locale and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        this.collator = localeID != null ? this.createFromLocale(localeID) : this.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                this.collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                this.collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                this.collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("quaternary")) {
                this.collator.setStrength(3);
            } else if (strength.equalsIgnoreCase("identical")) {
                this.collator.setStrength(15);
            } else {
                throw new IllegalArgumentException("Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                this.collator.setDecomposition(16);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                this.collator.setDecomposition(17);
            } else {
                throw new IllegalArgumentException("Invalid decomposition: " + decomposition);
            }
        }
        RuleBasedCollator rbc = (RuleBasedCollator)this.collator;
        if (alternate != null) {
            if (alternate.equalsIgnoreCase("shifted")) {
                rbc.setAlternateHandlingShifted(true);
            } else if (alternate.equalsIgnoreCase("non-ignorable")) {
                rbc.setAlternateHandlingShifted(false);
            } else {
                throw new IllegalArgumentException("Invalid alternate: " + alternate);
            }
        }
        if (caseLevel != null) {
            rbc.setCaseLevel(Boolean.parseBoolean(caseLevel));
        }
        if (caseFirst != null) {
            if (caseFirst.equalsIgnoreCase("lower")) {
                rbc.setLowerCaseFirst(true);
            } else if (caseFirst.equalsIgnoreCase("upper")) {
                rbc.setUpperCaseFirst(true);
            } else {
                throw new IllegalArgumentException("Invalid caseFirst: " + caseFirst);
            }
        }
        if (numeric != null) {
            rbc.setNumericCollation(Boolean.parseBoolean(numeric));
        }
        if (variableTop != null) {
            rbc.setVariableTop(variableTop);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ICUCollationKeyFilter(input, this.collator);
    }

    private Collator createFromLocale(String localeID) {
        return Collator.getInstance(new ULocale(localeID));
    }

    private Collator createFromRules(String fileName, ResourceLoader loader) {
        RuleBasedCollator ruleBasedCollator;
        InputStream input = null;
        try {
            input = loader.openResource(fileName);
            String rules = this.toUTF8String(input);
            ruleBasedCollator = new RuleBasedCollator(rules);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(input);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(input);
        return ruleBasedCollator;
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        return this;
    }

    private String toUTF8String(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        Reader r = IOUtils.getDecodingReader(in, IOUtils.CHARSET_UTF_8);
        int len = 0;
        while ((len = r.read(buffer)) > 0) {
            sb.append(buffer, 0, len);
        }
        return sb.toString();
    }
}

