/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import com.ibm.icu.text.Collator;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.collation.ICUCollationAttributeFactory;
import org.apache.lucene.collation.ICUCollationKeyFilter;
import org.apache.lucene.util.Version;

public final class ICUCollationKeyAnalyzer
extends Analyzer {
    private final Collator collator;
    private final ICUCollationAttributeFactory factory;
    private final Version matchVersion;

    public ICUCollationKeyAnalyzer(Version matchVersion, Collator collator) {
        this.matchVersion = matchVersion;
        this.collator = collator;
        this.factory = new ICUCollationAttributeFactory(collator);
    }

    @Deprecated
    public ICUCollationKeyAnalyzer(Collator collator) {
        this(Version.LUCENE_31, collator);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        if (this.matchVersion.onOrAfter(Version.LUCENE_40)) {
            KeywordTokenizer tokenizer = new KeywordTokenizer(this.factory, reader, 256);
            return new Analyzer.TokenStreamComponents(tokenizer, tokenizer);
        }
        KeywordTokenizer tokenizer = new KeywordTokenizer(reader);
        return new Analyzer.TokenStreamComponents(tokenizer, new ICUCollationKeyFilter(tokenizer, this.collator));
    }
}

