/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.UnicodeSet;
import java.text.CharacterIterator;
import org.apache.lucene.analysis.icu.segmentation.CharArrayIterator;

public class LaoBreakIterator
extends BreakIterator {
    RuleBasedBreakIterator rules;
    CharArrayIterator text;
    CharArrayIterator working = new CharArrayIterator();
    int workingOffset = 0;
    CharArrayIterator verifyText = new CharArrayIterator();
    RuleBasedBreakIterator verify;
    private static final UnicodeSet laoSet = new UnicodeSet("[:Lao:]");

    public LaoBreakIterator(RuleBasedBreakIterator rules) {
        this.rules = (RuleBasedBreakIterator)rules.clone();
        this.verify = (RuleBasedBreakIterator)rules.clone();
    }

    @Override
    public int current() {
        int current = this.rules.current();
        return current == -1 ? -1 : this.workingOffset + current;
    }

    @Override
    public int first() {
        this.working.setText(this.text.getText(), this.text.getStart(), this.text.getLength());
        this.rules.setText(this.working);
        this.workingOffset = 0;
        int first = this.rules.first();
        return first == -1 ? -1 : this.workingOffset + first;
    }

    @Override
    public int following(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharacterIterator getText() {
        return this.text;
    }

    @Override
    public int last() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int next() {
        int current = this.current();
        int next = this.rules.next();
        if (next == -1) {
            return next;
        }
        next += this.workingOffset;
        char c = this.working.current();
        int following = this.rules.next();
        if (following != -1) {
            following += this.workingOffset;
            if (this.rules.getRuleStatus() == 0 && laoSet.contains(c) && this.verifyPushBack(current, next)) {
                this.workingOffset = next - 1;
                this.working.setText(this.text.getText(), this.text.getStart() + this.workingOffset, this.text.getLength() - this.workingOffset);
                return next - 1;
            }
            this.rules.previous();
        }
        return next;
    }

    @Override
    public int next(int n) {
        if (n < 0) {
            throw new UnsupportedOperationException("Backwards traversal is unsupported");
        }
        int result = this.current();
        while (n > 0) {
            result = this.next();
            --n;
        }
        return result;
    }

    @Override
    public int previous() {
        throw new UnsupportedOperationException("Backwards traversal is unsupported");
    }

    @Override
    public void setText(CharacterIterator text) {
        if (!(text instanceof CharArrayIterator)) {
            throw new UnsupportedOperationException("unsupported CharacterIterator");
        }
        this.text = (CharArrayIterator)text;
        this.ccReorder(this.text.getText(), this.text.getStart(), this.text.getLength());
        this.working.setText(this.text.getText(), this.text.getStart(), this.text.getLength());
        this.rules.setText(this.working);
        this.workingOffset = 0;
    }

    @Override
    public void setText(String newText) {
        CharArrayIterator ci = new CharArrayIterator();
        ci.setText(newText.toCharArray(), 0, newText.length());
        this.setText(ci);
    }

    private boolean verifyPushBack(int current, int next) {
        int shortenedSyllable = next - current - 1;
        this.verifyText.setText(this.text.getText(), this.text.getStart() + current, shortenedSyllable);
        this.verify.setText(this.verifyText);
        if (this.verify.next() != shortenedSyllable || this.verify.getRuleStatus() == 0) {
            return false;
        }
        this.verifyText.setText(this.text.getText(), this.text.getStart() + next - 1, this.text.getLength() - next + 1);
        this.verify.setText(this.verifyText);
        return this.verify.next() != -1 && this.verify.getRuleStatus() != 0;
    }

    private void ccReorder(char[] text, int start, int length) {
        boolean reordered;
        do {
            int prevCC = 0;
            reordered = false;
            for (int i = start; i < start + length; ++i) {
                char c = text[i];
                int cc = UCharacter.getCombiningClass(c);
                if (cc > 0 && cc < prevCC) {
                    text[i] = text[i - 1];
                    text[i - 1] = c;
                    reordered = true;
                    continue;
                }
                prevCC = cc;
            }
        } while (reordered);
    }

    @Override
    public LaoBreakIterator clone() {
        LaoBreakIterator other = (LaoBreakIterator)super.clone();
        other.rules = (RuleBasedBreakIterator)this.rules.clone();
        other.verify = (RuleBasedBreakIterator)this.verify.clone();
        if (this.text != null) {
            other.text = this.text.clone();
        }
        if (this.working != null) {
            other.working = this.working.clone();
        }
        if (this.verifyText != null) {
            other.verifyText = this.verifyText.clone();
        }
        return other;
    }

    static {
        laoSet.compact();
        laoSet.freeze();
    }
}

