/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.icu.segmentation.DefaultICUTokenizerConfig;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizer;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.IOUtils;

public class ICUTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    static final String RULEFILES = "rulefiles";
    private Map<Integer, String> tailored;
    private ICUTokenizerConfig config;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.tailored = new HashMap<Integer, String>();
        String rulefilesArg = args.get(RULEFILES);
        if (rulefilesArg != null) {
            List<String> scriptAndResourcePaths = this.splitFileNames(rulefilesArg);
            for (String scriptAndResourcePath : scriptAndResourcePaths) {
                int colonPos = scriptAndResourcePath.indexOf(":");
                String scriptCode = scriptAndResourcePath.substring(0, colonPos).trim();
                String resourcePath = scriptAndResourcePath.substring(colonPos + 1).trim();
                this.tailored.put(UCharacter.getPropertyValueEnum((int)4106, (CharSequence)scriptCode), resourcePath);
            }
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        assert (this.tailored != null) : "init must be called first!";
        if (this.tailored.isEmpty()) {
            this.config = new DefaultICUTokenizerConfig();
        } else {
            final BreakIterator[] breakers = new BreakIterator[159];
            for (Map.Entry<Integer, String> entry : this.tailored.entrySet()) {
                int code = entry.getKey();
                String resourcePath = entry.getValue();
                breakers[code] = this.parseRules(resourcePath, loader);
            }
            this.config = new DefaultICUTokenizerConfig(){

                @Override
                public BreakIterator getBreakIterator(int script) {
                    if (breakers[script] != null) {
                        return (BreakIterator)breakers[script].clone();
                    }
                    return super.getBreakIterator(script);
                }
            };
        }
    }

    private BreakIterator parseRules(String filename, ResourceLoader loader) throws IOException {
        StringBuilder rules = new StringBuilder();
        InputStream rulesStream = loader.openResource(filename);
        BufferedReader reader = new BufferedReader(IOUtils.getDecodingReader(rulesStream, IOUtils.CHARSET_UTF_8));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("#")) {
                rules.append(line);
            }
            rules.append('\n');
        }
        reader.close();
        return new RuleBasedBreakIterator(rules.toString());
    }

    @Override
    public Tokenizer create(Reader input) {
        assert (this.config != null) : "inform must be called first!";
        return new ICUTokenizer(input, this.config);
    }
}

