/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.TypeTokenFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class TypeTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private boolean useWhitelist;
    private Set<String> stopTypes;
    private boolean enablePositionIncrements;

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String stopTypesFiles = (String)this.args.get("types");
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        this.useWhitelist = this.getBoolean("useWhitelist", false);
        if (stopTypesFiles != null) {
            List<String> files = this.splitFileNames(stopTypesFiles);
            if (files.size() > 0) {
                this.stopTypes = new HashSet<String>();
                for (String file : files) {
                    List<String> typesLines = this.getLines(loader, file.trim());
                    this.stopTypes.addAll(typesLines);
                }
            }
        } else {
            throw new IllegalArgumentException("Missing required parameter: types.");
        }
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public Set<String> getStopTypes() {
        return this.stopTypes;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new TypeTokenFilter(this.enablePositionIncrements, input, this.stopTypes, this.useWhitelist);
    }
}

