/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.helper;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Artist;
import org.musicbrainz.mmd2.ArtistCredit;
import org.musicbrainz.mmd2.NameCredit;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.helper.ArtistCreditWrapper;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.Utils;

public class ArtistCreditHelper {
    public static String buildFullArtistCreditName(ArtistCredit artistCredit) {
        StringBuffer sb = new StringBuffer();
        for (NameCredit nameCredit : artistCredit.getNameCredit()) {
            if (nameCredit.getName() != null) {
                sb.append(nameCredit.getName());
            } else {
                sb.append(nameCredit.getArtist().getName());
            }
            if (nameCredit.getJoinphrase() == null) continue;
            sb.append(nameCredit.getJoinphrase());
        }
        return sb.toString();
    }

    public static ArtistCredit unserialize(String artistCreditSerilized) {
        return (ArtistCredit)MMDSerializer.unserialize(artistCreditSerilized, ArtistCredit.class);
    }

    public static Map<Integer, ArtistCreditWrapper> completeArtistCreditFromDbResults(ResultSet rs, String entityKey, String artistCreditId, String artistId, String artistName, String artistSortName, String comment, String joinPhrase, String artistCreditName) throws SQLException {
        HashMap<Integer, ArtistCreditWrapper> artistCredits = new HashMap<Integer, ArtistCreditWrapper>();
        ObjectFactory of = new ObjectFactory();
        while (rs.next()) {
            String nameCredit;
            ArtistCredit ac;
            ArtistCreditWrapper acw;
            int entityId = rs.getInt(entityKey);
            if (!artistCredits.containsKey(entityId)) {
                acw = new ArtistCreditWrapper();
                acw.setArtistCreditId(rs.getInt(artistCreditId));
                ac = of.createArtistCredit();
                acw.setArtistCredit(ac);
                artistCredits.put(entityId, acw);
            } else {
                acw = (ArtistCreditWrapper)artistCredits.get(entityId);
                ac = acw.getArtistCredit();
            }
            NameCredit nc = of.createNameCredit();
            Artist artist = of.createArtist();
            artist.setId(rs.getString(artistId));
            artist.setName(rs.getString(artistName));
            artist.setSortName(rs.getString(artistSortName));
            String disamb = rs.getString(comment);
            if (disamb != null && !disamb.isEmpty()) {
                artist.setDisambiguation(disamb);
            }
            nc.setArtist(artist);
            String jp = rs.getString(joinPhrase);
            if (jp != null && !jp.isEmpty()) {
                nc.setJoinphrase(jp);
            }
            if (!(nameCredit = rs.getString(artistCreditName)).equals(artist.getName())) {
                nc.setName(nameCredit);
            }
            ac.getNameCredit().add(nc);
        }
        return artistCredits;
    }

    public static Map<Integer, ArtistCreditWrapper> updateArtistCreditWithAliases(Map<Integer, ArtistCreditWrapper> artistCredits, String entityKey, ResultSet rs) throws SQLException, IOException {
        ObjectFactory of = new ObjectFactory();
        int entityId = -1;
        int position = -1;
        NameCredit nc = null;
        while (rs.next()) {
            String end;
            String begin;
            String type;
            String locale;
            int currEntityId = rs.getInt(entityKey);
            int currPosition = rs.getInt("pos");
            if (currEntityId != entityId || currPosition != position) {
                ArtistCreditWrapper acw = artistCredits.get(currEntityId);
                if (acw == null) continue;
                if (currPosition >= acw.getArtistCredit().getNameCredit().size()) {
                    return artistCredits;
                }
                nc = acw.getArtistCredit().getNameCredit().get(currPosition);
                entityId = currEntityId;
                position = currPosition;
            }
            if (nc.getArtist().getAliasList() == null) {
                nc.getArtist().setAliasList(of.createAliasList());
            }
            List<Alias> aliasList = nc.getArtist().getAliasList().getAlias();
            Alias alias = of.createAlias();
            alias.setContent(rs.getString("name"));
            alias.setSortName(rs.getString("sort_name"));
            boolean isPrimary = rs.getBoolean("primary_for_locale");
            if (isPrimary) {
                alias.setPrimary("primary");
            }
            if ((locale = rs.getString("locale")) != null) {
                alias.setLocale(locale);
            }
            if ((type = rs.getString("type")) != null) {
                alias.setType(type);
            }
            if (!Strings.isNullOrEmpty(begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day")))) {
                alias.setBeginDate(begin);
            }
            if (!Strings.isNullOrEmpty(end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day")))) {
                alias.setEndDate(end);
            }
            aliasList.add(alias);
        }
        rs.close();
        return artistCredits;
    }

    public static void buildIndexFieldsFromArtistCredit(MbDocument doc, ArtistCredit ac, IndexField artist, IndexField artistNameCredit, IndexField artistId, IndexField artistName, IndexField artistCredit) {
        if (ac != null) {
            ArtistCreditHelper.buildIndexFieldsOnlyFromArtistCredit(doc, ac, artist, artistNameCredit, artistId, artistName);
            doc.addField(artistCredit, MMDSerializer.serialize(ac));
        }
    }

    public static void buildIndexFieldsOnlyFromArtistCredit(MbDocument doc, ArtistCredit ac, IndexField artist, IndexField artistNameCredit, IndexField artistId, IndexField artistName) {
        HashSet<String> aliasWithLocales = new HashSet<String>();
        if (ac != null) {
            doc.addField(artist, ArtistCreditHelper.buildFullArtistCreditName(ac));
            for (NameCredit nc : ac.getNameCredit()) {
                if (nc.getName() != null) {
                    doc.addField(artistNameCredit, nc.getName());
                } else {
                    doc.addField(artistNameCredit, nc.getArtist().getName());
                }
                doc.addField(artistId, nc.getArtist().getId());
                doc.addField(artistName, nc.getArtist().getName());
                if (nc.getArtist().getAliasList() != null && nc.getArtist().getAliasList().getAlias().size() > 0) {
                    for (Alias alias : nc.getArtist().getAliasList().getAlias()) {
                        aliasWithLocales.add(alias.getContent());
                    }
                }
                for (String next : aliasWithLocales) {
                    doc.addField(artistName, next);
                }
            }
        }
    }
}

