/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharacterUtils;
import org.apache.lucene.util.Version;

public final class UpperCaseFilter
extends TokenFilter {
    private final CharacterUtils charUtils;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public UpperCaseFilter(TokenStream in) {
        super(in);
        this.charUtils = CharacterUtils.getInstance();
    }

    @Deprecated
    public UpperCaseFilter(Version matchVersion, TokenStream in) {
        super(in);
        this.charUtils = CharacterUtils.getInstance(matchVersion);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.charUtils.toUpperCase(this.termAtt.buffer(), 0, this.termAtt.length());
            return true;
        }
        return false;
    }
}

