#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pylint',
 'pylint.checkers',
 'pylint.checkers.base',
 'pylint.checkers.base.name_checker',
 'pylint.checkers.classes',
 'pylint.checkers.refactoring',
 'pylint.config',
 'pylint.config._pylint_config',
 'pylint.extensions',
 'pylint.lint',
 'pylint.message',
 'pylint.pyreverse',
 'pylint.reporters',
 'pylint.reporters.ureports',
 'pylint.testutils',
 'pylint.testutils._primer',
 'pylint.testutils.functional',
 'pylint.utils']

package_data = \
{'': ['*']}

install_requires = \
['platformdirs>=2.2.0',
 'astroid>=2.12.13,<=2.14.0-dev0',
 'isort>=4.2.5,<6',
 'mccabe>=0.6,<0.8',
 'tomlkit>=0.10.1']

extras_require = \
{":python_version<'3.10'": ['typing-extensions>=3.10.0'],
 ":python_version<'3.11'": ['dill>=0.2', 'tomli>=1.1.0'],
 ":python_version>='3.11'": ['dill>=0.3.6'],
 ":sys_platform=='win32'": ['colorama>=0.4.5'],
 'spelling': ['pyenchant~=3.2'],
 'testutils': ['gitpython>3']}

entry_points = \
{'console_scripts': ['epylint = pylint:run_epylint',
                     'pylint = pylint:run_pylint',
                     'pylint-config = pylint:_run_pylint_config',
                     'pyreverse = pylint:run_pyreverse',
                     'symilar = pylint:run_symilar']}

setup(name='pylint',
      version='%%PORTVERSION%%',
      description='python code static checker',
      author=None,
      author_email='Python Code Quality Authority <code-quality@python.org>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7.2',
     )
