/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESShaderMultisampleInterpolation.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSOESShaderMultisampleInterpolationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESShaderMultisampleInterpolationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESShaderMultisampleInterpolationPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESShaderMultisampleInterpolationPrototype>(vm)) JSOESShaderMultisampleInterpolationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESShaderMultisampleInterpolationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESShaderMultisampleInterpolationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESShaderMultisampleInterpolationPrototype, JSOESShaderMultisampleInterpolationPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSOESShaderMultisampleInterpolationPrototypeTableValues[] =
{
    { "MIN_FRAGMENT_INTERPOLATION_OFFSET_OES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E5B } },
    { "MAX_FRAGMENT_INTERPOLATION_OFFSET_OES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E5C } },
    { "FRAGMENT_INTERPOLATION_OFFSET_BITS_OES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E5D } },
};

const ClassInfo JSOESShaderMultisampleInterpolationPrototype::s_info = { "OESShaderMultisampleInterpolation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESShaderMultisampleInterpolationPrototype) };

void JSOESShaderMultisampleInterpolationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESShaderMultisampleInterpolation::info(), JSOESShaderMultisampleInterpolationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESShaderMultisampleInterpolation::s_info = { "OESShaderMultisampleInterpolation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESShaderMultisampleInterpolation) };

JSOESShaderMultisampleInterpolation::JSOESShaderMultisampleInterpolation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESShaderMultisampleInterpolation>&& impl)
    : JSDOMWrapper<OESShaderMultisampleInterpolation>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESShaderMultisampleInterpolation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESShaderMultisampleInterpolation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESShaderMultisampleInterpolationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESShaderMultisampleInterpolationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESShaderMultisampleInterpolation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESShaderMultisampleInterpolation>(vm, globalObject);
}

void JSOESShaderMultisampleInterpolation::destroy(JSC::JSCell* cell)
{
    JSOESShaderMultisampleInterpolation* thisObject = static_cast<JSOESShaderMultisampleInterpolation*>(cell);
    thisObject->JSOESShaderMultisampleInterpolation::~JSOESShaderMultisampleInterpolation();
}

JSC::GCClient::IsoSubspace* JSOESShaderMultisampleInterpolation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESShaderMultisampleInterpolation, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESShaderMultisampleInterpolation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESShaderMultisampleInterpolation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESShaderMultisampleInterpolation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESShaderMultisampleInterpolation = std::forward<decltype(space)>(space); }
    );
}

void JSOESShaderMultisampleInterpolation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESShaderMultisampleInterpolation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESShaderMultisampleInterpolationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsOESShaderMultisampleInterpolation = jsCast<JSOESShaderMultisampleInterpolation*>(handle.slot()->asCell());
    auto& owner = jsOESShaderMultisampleInterpolation->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsOESShaderMultisampleInterpolation"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESShaderMultisampleInterpolationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESShaderMultisampleInterpolation = static_cast<JSOESShaderMultisampleInterpolation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESShaderMultisampleInterpolation->protectedWrapped().ptr(), jsOESShaderMultisampleInterpolation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESShaderMultisampleInterpolation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore33OESShaderMultisampleInterpolationE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, OESShaderMultisampleInterpolation>, void>> static inline void verifyVTable(OESShaderMultisampleInterpolation* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESShaderMultisampleInterpolation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore33OESShaderMultisampleInterpolationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESShaderMultisampleInterpolation has subclasses. If OESShaderMultisampleInterpolation has subclasses that get passed
        // to toJS() we currently require OESShaderMultisampleInterpolation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESShaderMultisampleInterpolation>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OESShaderMultisampleInterpolation>(impl.ptr());
#endif
    return createWrapper<OESShaderMultisampleInterpolation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESShaderMultisampleInterpolation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESShaderMultisampleInterpolation* JSOESShaderMultisampleInterpolation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESShaderMultisampleInterpolation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
