/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(NOTIFICATIONS)

#include "JSNotificationOptions.h"

#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSNotificationDirection.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(NOTIFICATIONS)

template<> ConversionResult<IDLDictionary<NotificationOptions>> convertDictionary<NotificationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    NotificationOptions result;
    JSValue bodyValue;
    if (isNullOrUndefined)
        bodyValue = jsUndefined();
    else {
        bodyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "body"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bodyConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, bodyValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(bodyConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.body = bodyConversionResult.releaseReturnValue();
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto dataConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, dataValue, [&]() -> ConversionResult<IDLAny> { return typename Converter<IDLAny>::ReturnType { jsNull() }; });
    if (UNLIKELY(dataConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.data = dataConversionResult.releaseReturnValue();
#if ENABLE(DECLARATIVE_WEB_PUSH)
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().declarativeWebPush) {
        JSValue defaultActionValue;
        if (isNullOrUndefined)
            defaultActionValue = jsUndefined();
        else {
            defaultActionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "defaultAction"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto defaultActionConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, defaultActionValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
        if (UNLIKELY(defaultActionConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.defaultAction = defaultActionConversionResult.releaseReturnValue();
    }
#endif
    JSValue dirValue;
    if (isNullOrUndefined)
        dirValue = jsUndefined();
    else {
        dirValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dir"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto dirConversionResult = convertOptionalWithDefault<IDLEnumeration<NotificationDirection>>(lexicalGlobalObject, dirValue, [&]() -> ConversionResult<IDLEnumeration<NotificationDirection>> { return Converter<IDLEnumeration<NotificationDirection>>::ReturnType { NotificationDirection::Auto }; });
    if (UNLIKELY(dirConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.dir = dirConversionResult.releaseReturnValue();
    JSValue iconValue;
    if (isNullOrUndefined)
        iconValue = jsUndefined();
    else {
        iconValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "icon"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!iconValue.isUndefined()) {
        auto iconConversionResult = convert<IDLUSVString>(lexicalGlobalObject, iconValue);
        if (UNLIKELY(iconConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.icon = iconConversionResult.releaseReturnValue();
    }
    JSValue langValue;
    if (isNullOrUndefined)
        langValue = jsUndefined();
    else {
        langValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lang"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto langConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, langValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(langConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.lang = langConversionResult.releaseReturnValue();
    JSValue silentValue;
    if (isNullOrUndefined)
        silentValue = jsUndefined();
    else {
        silentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "silent"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto silentConversionResult = convertOptionalWithDefault<IDLNullable<IDLBoolean>>(lexicalGlobalObject, silentValue, [&]() -> ConversionResult<IDLNullable<IDLBoolean>> { return typename Converter<IDLNullable<IDLBoolean>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(silentConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.silent = silentConversionResult.releaseReturnValue();
    JSValue tagValue;
    if (isNullOrUndefined)
        tagValue = jsUndefined();
    else {
        tagValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tag"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto tagConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, tagValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(tagConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.tag = tagConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(NOTIFICATIONS)
