/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaDecodingConfiguration.h"

#include "JSAudioConfiguration.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMGlobalObject.h"
#include "JSMediaDecodingType.h"
#include "JSVideoConfiguration.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<MediaDecodingConfiguration>> convertDictionary<MediaDecodingConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaDecodingConfiguration result;
    JSValue audioValue;
    if (isNullOrUndefined)
        audioValue = jsUndefined();
    else {
        audioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audio"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!audioValue.isUndefined()) {
        auto audioConversionResult = convert<IDLDictionary<AudioConfiguration>>(lexicalGlobalObject, audioValue);
        if (UNLIKELY(audioConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.audio = audioConversionResult.releaseReturnValue();
    }
    JSValue videoValue;
    if (isNullOrUndefined)
        videoValue = jsUndefined();
    else {
        videoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "video"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!videoValue.isUndefined()) {
        auto videoConversionResult = convert<IDLDictionary<VideoConfiguration>>(lexicalGlobalObject, videoValue);
        if (UNLIKELY(videoConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.video = videoConversionResult.releaseReturnValue();
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (typeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "type"_s, "MediaDecodingConfiguration"_s, "MediaDecodingType"_s);
        return ConversionResultException { };
    }
    auto typeConversionResult = convert<IDLEnumeration<MediaDecodingType>>(lexicalGlobalObject, typeValue);
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaDecodingConfiguration& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDictionary<AudioConfiguration>::isNullValue(dictionary.audio)) {
        auto audioValue = toJS<IDLDictionary<AudioConfiguration>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<AudioConfiguration>::extractValueFromNullable(dictionary.audio));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "audio"_s), audioValue);
    }
    if (!IDLDictionary<VideoConfiguration>::isNullValue(dictionary.video)) {
        auto videoValue = toJS<IDLDictionary<VideoConfiguration>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<VideoConfiguration>::extractValueFromNullable(dictionary.video));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "video"_s), videoValue);
    }
    auto typeValue = toJS<IDLEnumeration<MediaDecodingType>>(lexicalGlobalObject, throwScope, dictionary.type);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "type"_s), typeValue);
    return result;
}

} // namespace WebCore
