/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderBundle.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPURenderBundleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPURenderBundle_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPURenderBundle_label);

class JSGPURenderBundlePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPURenderBundlePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPURenderBundlePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPURenderBundlePrototype>(vm)) JSGPURenderBundlePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPURenderBundlePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPURenderBundlePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPURenderBundlePrototype, JSGPURenderBundlePrototype::Base);

using JSGPURenderBundleDOMConstructor = JSDOMConstructorNotConstructable<JSGPURenderBundle>;

template<> const ClassInfo JSGPURenderBundleDOMConstructor::s_info = { "GPURenderBundle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderBundleDOMConstructor) };

template<> JSValue JSGPURenderBundleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPURenderBundleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPURenderBundle"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPURenderBundle::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPURenderBundlePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPURenderBundleConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPURenderBundle_label, setJSGPURenderBundle_label } },
};

const ClassInfo JSGPURenderBundlePrototype::s_info = { "GPURenderBundle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderBundlePrototype) };

void JSGPURenderBundlePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPURenderBundle::info(), JSGPURenderBundlePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPURenderBundle::s_info = { "GPURenderBundle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderBundle) };

JSGPURenderBundle::JSGPURenderBundle(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPURenderBundle>&& impl)
    : JSDOMWrapper<GPURenderBundle>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPURenderBundle>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPURenderBundle::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPURenderBundlePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPURenderBundlePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPURenderBundle::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPURenderBundle>(vm, globalObject);
}

JSValue JSGPURenderBundle::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPURenderBundleDOMConstructor, DOMConstructorID::GPURenderBundle>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPURenderBundle::destroy(JSC::JSCell* cell)
{
    JSGPURenderBundle* thisObject = static_cast<JSGPURenderBundle*>(cell);
    thisObject->JSGPURenderBundle::~JSGPURenderBundle();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPURenderBundleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPURenderBundlePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPURenderBundle::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPURenderBundle_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPURenderBundle& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPURenderBundle_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPURenderBundle>::get<jsGPURenderBundle_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPURenderBundle_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPURenderBundle& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPURenderBundle_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPURenderBundle>::set<setJSGPURenderBundle_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPURenderBundle::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPURenderBundle, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPURenderBundle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPURenderBundle = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPURenderBundle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPURenderBundle = std::forward<decltype(space)>(space); }
    );
}

void JSGPURenderBundle::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPURenderBundle*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPURenderBundleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPURenderBundleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPURenderBundle = static_cast<JSGPURenderBundle*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPURenderBundle->protectedWrapped().ptr(), jsGPURenderBundle);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPURenderBundle@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15GPURenderBundleE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPURenderBundle>, void>> static inline void verifyVTable(GPURenderBundle* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPURenderBundle@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15GPURenderBundleE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPURenderBundle has subclasses. If GPURenderBundle has subclasses that get passed
        // to toJS() we currently require GPURenderBundle you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPURenderBundle>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPURenderBundle>(impl.ptr());
#endif
    return createWrapper<GPURenderBundle>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPURenderBundle& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPURenderBundle* JSGPURenderBundle::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPURenderBundle*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
