/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSExtendableCookieChangeEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCookieListItem.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSExtendableCookieChangeEventInit.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsExtendableCookieChangeEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableCookieChangeEvent_changed);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableCookieChangeEvent_deleted);

class JSExtendableCookieChangeEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSExtendableCookieChangeEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSExtendableCookieChangeEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSExtendableCookieChangeEventPrototype>(vm)) JSExtendableCookieChangeEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSExtendableCookieChangeEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSExtendableCookieChangeEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSExtendableCookieChangeEventPrototype, JSExtendableCookieChangeEventPrototype::Base);

using JSExtendableCookieChangeEventDOMConstructor = JSDOMConstructor<JSExtendableCookieChangeEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSExtendableCookieChangeEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSExtendableCookieChangeEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<ExtendableCookieChangeEventInit>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(eventInitDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = ExtendableCookieChangeEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ExtendableCookieChangeEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ExtendableCookieChangeEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSExtendableCookieChangeEventDOMConstructorConstruct, JSExtendableCookieChangeEventDOMConstructor::construct);

template<> const ClassInfo JSExtendableCookieChangeEventDOMConstructor::s_info = { "ExtendableCookieChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableCookieChangeEventDOMConstructor) };

template<> JSValue JSExtendableCookieChangeEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSExtendableEvent::getConstructor(vm, &globalObject);
}

template<> void JSExtendableCookieChangeEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ExtendableCookieChangeEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSExtendableCookieChangeEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSExtendableCookieChangeEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableCookieChangeEventConstructor, 0 } },
    { "changed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableCookieChangeEvent_changed, 0 } },
    { "deleted"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableCookieChangeEvent_deleted, 0 } },
};

const ClassInfo JSExtendableCookieChangeEventPrototype::s_info = { "ExtendableCookieChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableCookieChangeEventPrototype) };

void JSExtendableCookieChangeEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSExtendableCookieChangeEvent::info(), JSExtendableCookieChangeEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSExtendableCookieChangeEvent::s_info = { "ExtendableCookieChangeEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableCookieChangeEvent) };

JSExtendableCookieChangeEvent::JSExtendableCookieChangeEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ExtendableCookieChangeEvent>&& impl)
    : JSExtendableEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<ExtendableCookieChangeEvent> JSExtendableCookieChangeEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, ExtendableCookieChangeEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSExtendableCookieChangeEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSExtendableCookieChangeEventPrototype::createStructure(vm, &globalObject, JSExtendableEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSExtendableCookieChangeEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSExtendableCookieChangeEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSExtendableCookieChangeEvent>(vm, globalObject);
}

JSValue JSExtendableCookieChangeEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSExtendableCookieChangeEventDOMConstructor, DOMConstructorID::ExtendableCookieChangeEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableCookieChangeEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSExtendableCookieChangeEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSExtendableCookieChangeEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsExtendableCookieChangeEvent_changedGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableCookieChangeEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDictionary<CookieListItem>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.changed())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableCookieChangeEvent_changed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableCookieChangeEvent>::get<jsExtendableCookieChangeEvent_changedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableCookieChangeEvent_deletedGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableCookieChangeEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDictionary<CookieListItem>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.deleted())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableCookieChangeEvent_deleted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableCookieChangeEvent>::get<jsExtendableCookieChangeEvent_deletedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSExtendableCookieChangeEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSExtendableCookieChangeEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForExtendableCookieChangeEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForExtendableCookieChangeEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForExtendableCookieChangeEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForExtendableCookieChangeEvent = std::forward<decltype(space)>(space); }
    );
}

void JSExtendableCookieChangeEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSExtendableCookieChangeEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ExtendableCookieChangeEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27ExtendableCookieChangeEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, ExtendableCookieChangeEvent>, void>> static inline void verifyVTable(ExtendableCookieChangeEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ExtendableCookieChangeEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27ExtendableCookieChangeEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ExtendableCookieChangeEvent has subclasses. If ExtendableCookieChangeEvent has subclasses that get passed
        // to toJS() we currently require ExtendableCookieChangeEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ExtendableCookieChangeEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ExtendableCookieChangeEvent>(impl.ptr());
#endif
    return createWrapper<ExtendableCookieChangeEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ExtendableCookieChangeEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
