/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from Automation.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "AutomationFrontendDispatchers.h"

#include <JavaScriptCore/InspectorFrontendRouter.h>

namespace Inspector {

void AutomationFrontendDispatcher::fileChooserDismissed(const String& browsingContextHandle, bool selectionCancelled, RefPtr<JSON::ArrayOf<String>>&& opt_selectedFiles)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Automation.fileChooserDismissed"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("browsingContextHandle"_s, browsingContextHandle);
    protocol_paramsObject->setBoolean("selectionCancelled"_s, selectionCancelled);
    if (!!opt_selectedFiles)
        protocol_paramsObject->setArray("selectedFiles"_s, opt_selectedFiles.releaseNonNull());
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void AutomationFrontendDispatcher::browsingContextCleared(const String& browsingContextHandle)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Automation.browsingContextCleared"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("browsingContextHandle"_s, browsingContextHandle);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

} // namespace Inspector
