#!/usr/bin/bash
#
#   purge.sh - Remove unwanted files from the package
#
#   Copyright (c) 2008-2024 Pacman Development Team <pacman-dev@lists.archlinux.org>
#   Copyright (c) 2013-2016, 2018, 2024 Luke T. Shumaker <lukeshu@parabola.nu>
#
#   License: GNU GPLv2+
#
#   This file is part of LibreFetch
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

[[ -n $LIBMAKEPKG_TIDY_PURGE_SH ]] && return
LIBMAKEPKG_TIDY_PURGE_SH=1

MAKEPKG_LIBRARY=${MAKEPKG_LIBRARY:-'/usr/share/makepkg'}

source "$MAKEPKG_LIBRARY/util/message.sh"
source "$MAKEPKG_LIBRARY/util/option.sh"

packaging_options+=('purge')
tidy_remove+=('tidy_purge')

tidy_purge() {
	if check_option "purge" "y" && [[ -n ${PURGE_TARGETS[*]} ]]; then
		msg2 "$(gettext "Purging unwanted files...")"
		local pt
		for pt in "${PURGE_TARGETS[@]}"; do
			if [[ ${pt} == "${pt%/}" ]]; then
				# Normal makepkg behavior
				if [[ ${pt} == "${pt//\//}" ]]; then
					find . ! -type d -name "${pt}" -exec rm -f -- '{}' +
				else
					rm -f -- "${pt}"
				fi
			else
				# librefetch-enhanced ends-with-a-slash behavior
				if [[ ${pt%/} == "${pt//\//}" ]]; then
					find . -type d -name "${pt%/}" -exec rm -rf -- '{}' +
				else
					rm -rf -- "${pt}"
				fi
			fi
		done
	fi
}
