/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSPhotoSettings.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include "JSFillLightMode.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<PhotoSettings>> convertDictionary<PhotoSettings>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PhotoSettings result;
    JSValue fillLightModeValue;
    if (isNullOrUndefined)
        fillLightModeValue = jsUndefined();
    else {
        fillLightModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fillLightMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!fillLightModeValue.isUndefined()) {
        auto fillLightModeConversionResult = convert<IDLEnumeration<FillLightMode>>(lexicalGlobalObject, fillLightModeValue);
        if (UNLIKELY(fillLightModeConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.fillLightMode = fillLightModeConversionResult.releaseReturnValue();
    }
    JSValue imageHeightValue;
    if (isNullOrUndefined)
        imageHeightValue = jsUndefined();
    else {
        imageHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "imageHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!imageHeightValue.isUndefined()) {
        auto imageHeightConversionResult = convert<IDLDouble>(lexicalGlobalObject, imageHeightValue);
        if (UNLIKELY(imageHeightConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.imageHeight = imageHeightConversionResult.releaseReturnValue();
    }
    JSValue imageWidthValue;
    if (isNullOrUndefined)
        imageWidthValue = jsUndefined();
    else {
        imageWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "imageWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!imageWidthValue.isUndefined()) {
        auto imageWidthConversionResult = convert<IDLDouble>(lexicalGlobalObject, imageWidthValue);
        if (UNLIKELY(imageWidthConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.imageWidth = imageWidthConversionResult.releaseReturnValue();
    }
    JSValue redEyeReductionValue;
    if (isNullOrUndefined)
        redEyeReductionValue = jsUndefined();
    else {
        redEyeReductionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "redEyeReduction"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!redEyeReductionValue.isUndefined()) {
        auto redEyeReductionConversionResult = convert<IDLBoolean>(lexicalGlobalObject, redEyeReductionValue);
        if (UNLIKELY(redEyeReductionConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.redEyeReduction = redEyeReductionConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const PhotoSettings& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLEnumeration<FillLightMode>::isNullValue(dictionary.fillLightMode)) {
        auto fillLightModeValue = toJS<IDLEnumeration<FillLightMode>>(lexicalGlobalObject, throwScope, IDLEnumeration<FillLightMode>::extractValueFromNullable(dictionary.fillLightMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fillLightMode"_s), fillLightModeValue);
    }
    if (!IDLDouble::isNullValue(dictionary.imageHeight)) {
        auto imageHeightValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.imageHeight));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "imageHeight"_s), imageHeightValue);
    }
    if (!IDLDouble::isNullValue(dictionary.imageWidth)) {
        auto imageWidthValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.imageWidth));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "imageWidth"_s), imageWidthValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.redEyeReduction)) {
        auto redEyeReductionValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.redEyeReduction));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "redEyeReduction"_s), redEyeReductionValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(MEDIA_STREAM)
