/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD)

#include "JSGamepadHapticActuator.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSGamepadEffectParameters.h"
#include "JSGamepadHapticEffectType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GamepadHapticActuator::Type enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("vibration"),
        MAKE_STATIC_STRING_IMPL("dual-rumble"),
    };
    static_assert(static_cast<size_t>(GamepadHapticActuator::Type::Vibration) == 0, "GamepadHapticActuator::Type::Vibration is not 0 as expected");
    static_assert(static_cast<size_t>(GamepadHapticActuator::Type::DualRumble) == 1, "GamepadHapticActuator::Type::DualRumble is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GamepadHapticActuator::Type enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GamepadHapticActuator::Type> parseEnumerationFromString<GamepadHapticActuator::Type>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GamepadHapticActuator::Type> mappings[] = {
        { "dual-rumble", GamepadHapticActuator::Type::DualRumble },
        { "vibration", GamepadHapticActuator::Type::Vibration },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GamepadHapticActuator::Type> parseEnumeration<GamepadHapticActuator::Type>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GamepadHapticActuator::Type>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GamepadHapticActuator::Type>()
{
    return "\"vibration\", \"dual-rumble\""_s;
}

String convertEnumerationToString(GamepadHapticActuator::Result enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("complete"),
        MAKE_STATIC_STRING_IMPL("preempted"),
    };
    static_assert(static_cast<size_t>(GamepadHapticActuator::Result::Complete) == 0, "GamepadHapticActuator::Result::Complete is not 0 as expected");
    static_assert(static_cast<size_t>(GamepadHapticActuator::Result::Preempted) == 1, "GamepadHapticActuator::Result::Preempted is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GamepadHapticActuator::Result enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GamepadHapticActuator::Result> parseEnumerationFromString<GamepadHapticActuator::Result>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GamepadHapticActuator::Result> mappings[] = {
        { "complete", GamepadHapticActuator::Result::Complete },
        { "preempted", GamepadHapticActuator::Result::Preempted },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GamepadHapticActuator::Result> parseEnumeration<GamepadHapticActuator::Result>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GamepadHapticActuator::Result>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GamepadHapticActuator::Result>()
{
    return "\"complete\", \"preempted\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGamepadHapticActuatorPrototypeFunction_canPlayEffectType);
static JSC_DECLARE_HOST_FUNCTION(jsGamepadHapticActuatorPrototypeFunction_playEffect);
static JSC_DECLARE_HOST_FUNCTION(jsGamepadHapticActuatorPrototypeFunction_reset);
static JSC_DECLARE_HOST_FUNCTION(jsGamepadHapticActuatorPrototypeFunction_canPlay);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGamepadHapticActuatorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGamepadHapticActuator_type);

class JSGamepadHapticActuatorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGamepadHapticActuatorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGamepadHapticActuatorPrototype* ptr = new (NotNull, JSC::allocateCell<JSGamepadHapticActuatorPrototype>(vm)) JSGamepadHapticActuatorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGamepadHapticActuatorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGamepadHapticActuatorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGamepadHapticActuatorPrototype, JSGamepadHapticActuatorPrototype::Base);

using JSGamepadHapticActuatorDOMConstructor = JSDOMConstructorNotConstructable<JSGamepadHapticActuator>;

template<> const ClassInfo JSGamepadHapticActuatorDOMConstructor::s_info = { "GamepadHapticActuator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGamepadHapticActuatorDOMConstructor) };

template<> JSValue JSGamepadHapticActuatorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGamepadHapticActuatorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GamepadHapticActuator"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGamepadHapticActuator::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGamepadHapticActuatorPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGamepadHapticActuatorConstructor, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGamepadHapticActuator_type, 0 } },
    { "canPlayEffectType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGamepadHapticActuatorPrototypeFunction_canPlayEffectType, 1 } },
    { "playEffect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGamepadHapticActuatorPrototypeFunction_playEffect, 1 } },
    { "reset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGamepadHapticActuatorPrototypeFunction_reset, 0 } },
    { "canPlay"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGamepadHapticActuatorPrototypeFunction_canPlay, 1 } },
};

const ClassInfo JSGamepadHapticActuatorPrototype::s_info = { "GamepadHapticActuator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGamepadHapticActuatorPrototype) };

void JSGamepadHapticActuatorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGamepadHapticActuator::info(), JSGamepadHapticActuatorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGamepadHapticActuator::s_info = { "GamepadHapticActuator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGamepadHapticActuator) };

JSGamepadHapticActuator::JSGamepadHapticActuator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GamepadHapticActuator>&& impl)
    : JSDOMWrapper<GamepadHapticActuator>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, GamepadHapticActuator>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSGamepadHapticActuator::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGamepadHapticActuatorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGamepadHapticActuatorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGamepadHapticActuator::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGamepadHapticActuator>(vm, globalObject);
}

JSValue JSGamepadHapticActuator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGamepadHapticActuatorDOMConstructor, DOMConstructorID::GamepadHapticActuator>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGamepadHapticActuator::destroy(JSC::JSCell* cell)
{
    JSGamepadHapticActuator* thisObject = static_cast<JSGamepadHapticActuator*>(cell);
    thisObject->JSGamepadHapticActuator::~JSGamepadHapticActuator();
}

JSC_DEFINE_CUSTOM_GETTER(jsGamepadHapticActuatorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGamepadHapticActuatorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGamepadHapticActuator::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGamepadHapticActuator_typeGetter(JSGlobalObject& lexicalGlobalObject, JSGamepadHapticActuator& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<GamepadHapticActuator::Type>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGamepadHapticActuator_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGamepadHapticActuator>::get<jsGamepadHapticActuator_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsGamepadHapticActuatorPrototypeFunction_canPlayEffectTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGamepadHapticActuator>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLEnumeration<GamepadHapticEffectType>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "type"_s, "GamepadHapticActuator"_s, "canPlayEffectType"_s, expectedEnumerationValues<GamepadHapticEffectType>()); });
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.canPlayEffectType(typeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGamepadHapticActuatorPrototypeFunction_canPlayEffectType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGamepadHapticActuator>::call<jsGamepadHapticActuatorPrototypeFunction_canPlayEffectTypeBody>(*lexicalGlobalObject, *callFrame, "canPlayEffectType");
}

static inline JSC::EncodedJSValue jsGamepadHapticActuatorPrototypeFunction_playEffectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGamepadHapticActuator>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLEnumeration<GamepadHapticEffectType>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "type"_s, "GamepadHapticActuator"_s, "playEffect"_s, expectedEnumerationValues<GamepadHapticEffectType>()); });
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto paramsConversionResult = convert<IDLDictionary<GamepadEffectParameters>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(paramsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLEnumeration<GamepadHapticActuator::Result>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.playEffect(typeConversionResult.releaseReturnValue(), paramsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGamepadHapticActuatorPrototypeFunction_playEffect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGamepadHapticActuator>::call<jsGamepadHapticActuatorPrototypeFunction_playEffectBody>(*lexicalGlobalObject, *callFrame, "playEffect");
}

static inline JSC::EncodedJSValue jsGamepadHapticActuatorPrototypeFunction_resetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGamepadHapticActuator>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLEnumeration<GamepadHapticActuator::Result>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.reset(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGamepadHapticActuatorPrototypeFunction_reset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGamepadHapticActuator>::call<jsGamepadHapticActuatorPrototypeFunction_resetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

static inline JSC::EncodedJSValue jsGamepadHapticActuatorPrototypeFunction_canPlayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGamepadHapticActuator>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLEnumeration<GamepadHapticEffectType>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "type"_s, "GamepadHapticActuator"_s, "canPlay"_s, expectedEnumerationValues<GamepadHapticEffectType>()); });
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.canPlayEffectType(typeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGamepadHapticActuatorPrototypeFunction_canPlay, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGamepadHapticActuator>::call<jsGamepadHapticActuatorPrototypeFunction_canPlayBody>(*lexicalGlobalObject, *callFrame, "canPlay");
}

JSC::GCClient::IsoSubspace* JSGamepadHapticActuator::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGamepadHapticActuator, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGamepadHapticActuator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGamepadHapticActuator = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGamepadHapticActuator.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGamepadHapticActuator = std::forward<decltype(space)>(space); }
    );
}

void JSGamepadHapticActuator::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGamepadHapticActuator*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGamepadHapticActuatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsGamepadHapticActuator = jsCast<JSGamepadHapticActuator*>(handle.slot()->asCell());
    auto& wrapped = jsGamepadHapticActuator->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGamepadHapticActuatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGamepadHapticActuator = static_cast<JSGamepadHapticActuator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGamepadHapticActuator->protectedWrapped().ptr(), jsGamepadHapticActuator);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GamepadHapticActuator@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21GamepadHapticActuatorE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GamepadHapticActuator>, void>> static inline void verifyVTable(GamepadHapticActuator* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GamepadHapticActuator@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21GamepadHapticActuatorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GamepadHapticActuator has subclasses. If GamepadHapticActuator has subclasses that get passed
        // to toJS() we currently require GamepadHapticActuator you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GamepadHapticActuator>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GamepadHapticActuator>(impl.ptr());
#endif
    return createWrapper<GamepadHapticActuator>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GamepadHapticActuator& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GamepadHapticActuator* JSGamepadHapticActuator::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGamepadHapticActuator*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GAMEPAD)
