/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureUsage.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUTextureUsageConstructor);

class JSGPUTextureUsagePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUTextureUsagePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUTextureUsagePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUTextureUsagePrototype>(vm)) JSGPUTextureUsagePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUTextureUsagePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUTextureUsagePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUTextureUsagePrototype, JSGPUTextureUsagePrototype::Base);

using JSGPUTextureUsageDOMConstructor = JSDOMConstructorNotConstructable<JSGPUTextureUsage>;

/* Hash table for constructor */

static const HashTableValue JSGPUTextureUsageConstructorTableValues[] =
{
    { "COPY_SRC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    { "COPY_DST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
    { "TEXTURE_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x04 } },
    { "STORAGE_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x08 } },
    { "RENDER_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x10 } },
};

static_assert(GPUTextureUsage::COPY_SRC == 0x01, "COPY_SRC in GPUTextureUsage does not match value from IDL");
static_assert(GPUTextureUsage::COPY_DST == 0x02, "COPY_DST in GPUTextureUsage does not match value from IDL");
static_assert(GPUTextureUsage::TEXTURE_BINDING == 0x04, "TEXTURE_BINDING in GPUTextureUsage does not match value from IDL");
static_assert(GPUTextureUsage::STORAGE_BINDING == 0x08, "STORAGE_BINDING in GPUTextureUsage does not match value from IDL");
static_assert(GPUTextureUsage::RENDER_ATTACHMENT == 0x10, "RENDER_ATTACHMENT in GPUTextureUsage does not match value from IDL");

template<> const ClassInfo JSGPUTextureUsageDOMConstructor::s_info = { "GPUTextureUsage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUTextureUsageDOMConstructor) };

template<> JSValue JSGPUTextureUsageDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUTextureUsageDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUTextureUsage"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUTextureUsage::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSGPUTextureUsage::info(), JSGPUTextureUsageConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSGPUTextureUsagePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUTextureUsageConstructor, 0 } },
    { "COPY_SRC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    { "COPY_DST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
    { "TEXTURE_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x04 } },
    { "STORAGE_BINDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x08 } },
    { "RENDER_ATTACHMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x10 } },
};

const ClassInfo JSGPUTextureUsagePrototype::s_info = { "GPUTextureUsage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUTextureUsagePrototype) };

void JSGPUTextureUsagePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUTextureUsage::info(), JSGPUTextureUsagePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUTextureUsage::s_info = { "GPUTextureUsage"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUTextureUsage) };

JSGPUTextureUsage::JSGPUTextureUsage(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUTextureUsage>&& impl)
    : JSDOMWrapper<GPUTextureUsage>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUTextureUsage>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUTextureUsage::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUTextureUsagePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUTextureUsagePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUTextureUsage::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUTextureUsage>(vm, globalObject);
}

JSValue JSGPUTextureUsage::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUTextureUsageDOMConstructor, DOMConstructorID::GPUTextureUsage>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUTextureUsage::destroy(JSC::JSCell* cell)
{
    JSGPUTextureUsage* thisObject = static_cast<JSGPUTextureUsage*>(cell);
    thisObject->JSGPUTextureUsage::~JSGPUTextureUsage();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUTextureUsageConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUTextureUsagePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUTextureUsage::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSGPUTextureUsage::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUTextureUsage, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUTextureUsage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUTextureUsage = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUTextureUsage.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUTextureUsage = std::forward<decltype(space)>(space); }
    );
}

void JSGPUTextureUsage::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUTextureUsage*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUTextureUsageOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUTextureUsageOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUTextureUsage = static_cast<JSGPUTextureUsage*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUTextureUsage->protectedWrapped().ptr(), jsGPUTextureUsage);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUTextureUsage@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15GPUTextureUsageE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPUTextureUsage>, void>> static inline void verifyVTable(GPUTextureUsage* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUTextureUsage@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15GPUTextureUsageE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUTextureUsage has subclasses. If GPUTextureUsage has subclasses that get passed
        // to toJS() we currently require GPUTextureUsage you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUTextureUsage>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUTextureUsage>(impl.ptr());
#endif
    return createWrapper<GPUTextureUsage>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUTextureUsage& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUTextureUsage* JSGPUTextureUsage::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUTextureUsage*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
