/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathNSResolver.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsXPathNSResolverPrototypeFunction_lookupNamespaceURI);

class JSXPathNSResolverPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXPathNSResolverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathNSResolverPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathNSResolverPrototype>(vm)) JSXPathNSResolverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathNSResolverPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathNSResolverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathNSResolverPrototype, JSXPathNSResolverPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSXPathNSResolverPrototypeTableValues[] =
{
    { "lookupNamespaceURI"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXPathNSResolverPrototypeFunction_lookupNamespaceURI, 1 } },
};

const ClassInfo JSXPathNSResolverPrototype::s_info = { "XPathNSResolver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathNSResolverPrototype) };

void JSXPathNSResolverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathNSResolver::info(), JSXPathNSResolverPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXPathNSResolver::s_info = { "XPathNSResolver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathNSResolver) };

JSXPathNSResolver::JSXPathNSResolver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathNSResolver>&& impl)
    : JSDOMWrapper<XPathNSResolver>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, XPathNSResolver>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSXPathNSResolver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXPathNSResolverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSXPathNSResolverPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXPathNSResolver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXPathNSResolver>(vm, globalObject);
}

void JSXPathNSResolver::destroy(JSC::JSCell* cell)
{
    JSXPathNSResolver* thisObject = static_cast<JSXPathNSResolver*>(cell);
    thisObject->JSXPathNSResolver::~JSXPathNSResolver();
}

static inline JSC::EncodedJSValue jsXPathNSResolverPrototypeFunction_lookupNamespaceURIBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathNSResolver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto prefix = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.lookupNamespaceURI(WTFMove(prefix)))));
}

JSC_DEFINE_HOST_FUNCTION(jsXPathNSResolverPrototypeFunction_lookupNamespaceURI, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXPathNSResolver>::call<jsXPathNSResolverPrototypeFunction_lookupNamespaceURIBody>(*lexicalGlobalObject, *callFrame, "lookupNamespaceURI");
}

JSC::GCClient::IsoSubspace* JSXPathNSResolver::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXPathNSResolver, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXPathNSResolver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXPathNSResolver = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXPathNSResolver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXPathNSResolver = std::forward<decltype(space)>(space); }
    );
}

void JSXPathNSResolver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXPathNSResolver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXPathNSResolverOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXPathNSResolverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathNSResolver = static_cast<JSXPathNSResolver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathNSResolver->wrapped(), jsXPathNSResolver);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XPathNSResolver>&& impl)
{
    return createWrapper<XPathNSResolver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XPathNSResolver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XPathNSResolver* JSXPathNSResolver::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathNSResolver*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
