/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWindowPostMessageOptions.h"

#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> WindowPostMessageOptions convertDictionary<WindowPostMessageOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WindowPostMessageOptions result;
    JSValue transferValue;
    if (isNullOrUndefined)
        transferValue = jsUndefined();
    else {
        transferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transfer"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transferValue.isUndefined()) {
        result.transfer = convert<IDLSequence<IDLObject>>(lexicalGlobalObject, transferValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.transfer = Converter<IDLSequence<IDLObject>>::ReturnType{ };
    JSValue targetOriginValue;
    if (isNullOrUndefined)
        targetOriginValue = jsUndefined();
    else {
        targetOriginValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetOrigin"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetOriginValue.isUndefined()) {
        result.targetOrigin = convert<IDLUSVString>(lexicalGlobalObject, targetOriginValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.targetOrigin = "/"_s;
    return result;
}

} // namespace WebCore
