/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUndoManager.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSUndoItem.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsUndoManagerPrototypeFunction_addItem);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsUndoManagerConstructor);

class JSUndoManagerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSUndoManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSUndoManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSUndoManagerPrototype>(vm)) JSUndoManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUndoManagerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSUndoManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSUndoManagerPrototype, JSUndoManagerPrototype::Base);

using JSUndoManagerDOMConstructor = JSDOMConstructorNotConstructable<JSUndoManager>;

template<> const ClassInfo JSUndoManagerDOMConstructor::s_info = { "UndoManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoManagerDOMConstructor) };

template<> JSValue JSUndoManagerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSUndoManagerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "UndoManager"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSUndoManager::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSUndoManagerPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsUndoManagerConstructor, 0 } },
    { "addItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsUndoManagerPrototypeFunction_addItem, 1 } },
};

const ClassInfo JSUndoManagerPrototype::s_info = { "UndoManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoManagerPrototype) };

void JSUndoManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSUndoManager::info(), JSUndoManagerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSUndoManager::s_info = { "UndoManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSUndoManager) };

JSUndoManager::JSUndoManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<UndoManager>&& impl)
    : JSDOMWrapper<UndoManager>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, UndoManager>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSUndoManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSUndoManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSUndoManagerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSUndoManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSUndoManager>(vm, globalObject);
}

JSValue JSUndoManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUndoManagerDOMConstructor, DOMConstructorID::UndoManager>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSUndoManager::destroy(JSC::JSCell* cell)
{
    JSUndoManager* thisObject = static_cast<JSUndoManager*>(cell);
    thisObject->JSUndoManager::~JSUndoManager();
}

JSC_DEFINE_CUSTOM_GETTER(jsUndoManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSUndoManagerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSUndoManager::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsUndoManagerPrototypeFunction_addItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSUndoManager>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto item = convert<IDLInterface<UndoItem>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "item", "UndoManager", "addItem", "UndoItem"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.addItem(*item); })));
}

JSC_DEFINE_HOST_FUNCTION(jsUndoManagerPrototypeFunction_addItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSUndoManager>::call<jsUndoManagerPrototypeFunction_addItemBody>(*lexicalGlobalObject, *callFrame, "addItem");
}

JSC::GCClient::IsoSubspace* JSUndoManager::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSUndoManager, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForUndoManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForUndoManager = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForUndoManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForUndoManager = std::forward<decltype(space)>(space); }
    );
}

void JSUndoManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSUndoManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSUndoManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsUndoManager = jsCast<JSUndoManager*>(handle.slot()->asCell());
    Document* owner = WTF::getPtr(jsUndoManager->wrapped().document());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Document";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSUndoManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsUndoManager = static_cast<JSUndoManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsUndoManager->wrapped(), jsUndoManager);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7UndoManager@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11UndoManagerE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<UndoManager>&& impl)
{

    if constexpr (std::is_polymorphic_v<UndoManager>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7UndoManager@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11UndoManagerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // UndoManager has subclasses. If UndoManager has subclasses that get passed
        // to toJS() we currently require UndoManager you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<UndoManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, UndoManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

UndoManager* JSUndoManager::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSUndoManager*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
