/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStyleSheet.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaList.h"
#include "JSNode.h"
#include "JSStyleSheet.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsStyleSheetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsStyleSheet_type);
static JSC_DECLARE_CUSTOM_GETTER(jsStyleSheet_disabled);
static JSC_DECLARE_CUSTOM_SETTER(setJSStyleSheet_disabled);
static JSC_DECLARE_CUSTOM_GETTER(jsStyleSheet_ownerNode);
static JSC_DECLARE_CUSTOM_GETTER(jsStyleSheet_parentStyleSheet);
static JSC_DECLARE_CUSTOM_GETTER(jsStyleSheet_href);
static JSC_DECLARE_CUSTOM_GETTER(jsStyleSheet_title);
static JSC_DECLARE_CUSTOM_GETTER(jsStyleSheet_media);
static JSC_DECLARE_CUSTOM_SETTER(setJSStyleSheet_media);

class JSStyleSheetPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStyleSheetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStyleSheetPrototype* ptr = new (NotNull, JSC::allocateCell<JSStyleSheetPrototype>(vm)) JSStyleSheetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStyleSheetPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStyleSheetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStyleSheetPrototype, JSStyleSheetPrototype::Base);

using JSStyleSheetDOMConstructor = JSDOMConstructorNotConstructable<JSStyleSheet>;

template<> const ClassInfo JSStyleSheetDOMConstructor::s_info = { "StyleSheet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStyleSheetDOMConstructor) };

template<> JSValue JSStyleSheetDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSStyleSheetDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "StyleSheet"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSStyleSheet::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSStyleSheetPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsStyleSheetConstructor, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStyleSheet_type, 0 } },
    { "disabled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStyleSheet_disabled, setJSStyleSheet_disabled } },
    { "ownerNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStyleSheet_ownerNode, 0 } },
    { "parentStyleSheet"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStyleSheet_parentStyleSheet, 0 } },
    { "href"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStyleSheet_href, 0 } },
    { "title"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStyleSheet_title, 0 } },
    { "media"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsStyleSheet_media, setJSStyleSheet_media } },
};

const ClassInfo JSStyleSheetPrototype::s_info = { "StyleSheet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStyleSheetPrototype) };

void JSStyleSheetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStyleSheet::info(), JSStyleSheetPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSStyleSheet::s_info = { "StyleSheet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStyleSheet) };

JSStyleSheet::JSStyleSheet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StyleSheet>&& impl)
    : JSDOMWrapper<StyleSheet>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, StyleSheet>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSStyleSheet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSStyleSheetPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSStyleSheetPrototype::create(vm, &globalObject, structure);
}

JSObject* JSStyleSheet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStyleSheet>(vm, globalObject);
}

JSValue JSStyleSheet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStyleSheetDOMConstructor, DOMConstructorID::StyleSheet>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSStyleSheet::destroy(JSC::JSCell* cell)
{
    JSStyleSheet* thisObject = static_cast<JSStyleSheet*>(cell);
    thisObject->JSStyleSheet::~JSStyleSheet();
}

JSC_DEFINE_CUSTOM_GETTER(jsStyleSheetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStyleSheetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStyleSheet::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsStyleSheet_typeGetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStyleSheet_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::get<jsStyleSheet_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStyleSheet_disabledGetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.disabled())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStyleSheet_disabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::get<jsStyleSheet_disabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSStyleSheet_disabledSetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDisabled(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSStyleSheet_disabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::set<setJSStyleSheet_disabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsStyleSheet_ownerNodeGetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ownerNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStyleSheet_ownerNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::get<jsStyleSheet_ownerNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStyleSheet_parentStyleSheetGetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<StyleSheet>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parentStyleSheet())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStyleSheet_parentStyleSheet, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::get<jsStyleSheet_parentStyleSheetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStyleSheet_hrefGetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.href())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStyleSheet_href, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::get<jsStyleSheet_hrefGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStyleSheet_titleGetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.title())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStyleSheet_title, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::get<jsStyleSheet_titleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsStyleSheet_mediaGetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.media())));
}

JSC_DEFINE_CUSTOM_GETTER(jsStyleSheet_media, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::get<jsStyleSheet_mediaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSStyleSheet_mediaSetter(JSGlobalObject& lexicalGlobalObject, JSStyleSheet& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto id = Identifier::fromString(vm, "media"_s);
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, "mediaText"_s);
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable()->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSStyleSheet_media, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSStyleSheet>::set<setJSStyleSheet_mediaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSStyleSheet::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSStyleSheet, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForStyleSheet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForStyleSheet = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForStyleSheet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForStyleSheet = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSStyleSheet::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSStyleSheet*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSStyleSheet);

template<typename Visitor>
void JSStyleSheet::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSStyleSheet*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSStyleSheet::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSStyleSheet::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSStyleSheet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStyleSheet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSStyleSheetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsStyleSheet = jsCast<JSStyleSheet*>(handle.slot()->asCell());
    auto& owner = jsStyleSheet->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsStyleSheet";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSStyleSheetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsStyleSheet = static_cast<JSStyleSheet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsStyleSheet->wrapped(), jsStyleSheet);
}

StyleSheet* JSStyleSheet::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStyleSheet*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
