/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSResizeObserver.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSResizeObserverCallback.h"
#include "JSResizeObserverOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsResizeObserverPrototypeFunction_observe);
static JSC_DECLARE_HOST_FUNCTION(jsResizeObserverPrototypeFunction_unobserve);
static JSC_DECLARE_HOST_FUNCTION(jsResizeObserverPrototypeFunction_disconnect);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsResizeObserverConstructor);

class JSResizeObserverPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSResizeObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSResizeObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSResizeObserverPrototype>(vm)) JSResizeObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSResizeObserverPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSResizeObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSResizeObserverPrototype, JSResizeObserverPrototype::Base);

using JSResizeObserverDOMConstructor = JSDOMConstructor<JSResizeObserver>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSResizeObserverDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSResizeObserverDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "ResizeObserver");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callback = convert<IDLCallbackFunction<JSResizeObserverCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "ResizeObserver", nullptr); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ResizeObserver::create(document, callback.releaseNonNull());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ResizeObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ResizeObserver>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSResizeObserverDOMConstructorConstruct, JSResizeObserverDOMConstructor::construct);

template<> const ClassInfo JSResizeObserverDOMConstructor::s_info = { "ResizeObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverDOMConstructor) };

template<> JSValue JSResizeObserverDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSResizeObserverDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ResizeObserver"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSResizeObserver::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSResizeObserverPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsResizeObserverConstructor, 0 } },
    { "observe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsResizeObserverPrototypeFunction_observe, 1 } },
    { "unobserve"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsResizeObserverPrototypeFunction_unobserve, 1 } },
    { "disconnect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsResizeObserverPrototypeFunction_disconnect, 0 } },
};

const ClassInfo JSResizeObserverPrototype::s_info = { "ResizeObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverPrototype) };

void JSResizeObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSResizeObserver::info(), JSResizeObserverPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSResizeObserver::s_info = { "ResizeObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserver) };

JSResizeObserver::JSResizeObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ResizeObserver>&& impl)
    : JSDOMWrapper<ResizeObserver>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSResizeObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSResizeObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSResizeObserverPrototype::create(vm, &globalObject, structure);
}

JSObject* JSResizeObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSResizeObserver>(vm, globalObject);
}

JSValue JSResizeObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSResizeObserverDOMConstructor, DOMConstructorID::ResizeObserver>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSResizeObserver::destroy(JSC::JSCell* cell)
{
    JSResizeObserver* thisObject = static_cast<JSResizeObserver*>(cell);
    thisObject->JSResizeObserver::~JSResizeObserver();
}

JSC_DEFINE_CUSTOM_GETTER(jsResizeObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSResizeObserverPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSResizeObserver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsResizeObserverPrototypeFunction_observeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSResizeObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLInterface<Element>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "ResizeObserver", "observe", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<ResizeObserverOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.observe(*target, WTFMove(options)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsResizeObserverPrototypeFunction_observe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSResizeObserver>::call<jsResizeObserverPrototypeFunction_observeBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsResizeObserverPrototypeFunction_unobserveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSResizeObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLInterface<Element>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "ResizeObserver", "unobserve", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.unobserve(*target); })));
}

JSC_DEFINE_HOST_FUNCTION(jsResizeObserverPrototypeFunction_unobserve, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSResizeObserver>::call<jsResizeObserverPrototypeFunction_unobserveBody>(*lexicalGlobalObject, *callFrame, "unobserve");
}

static inline JSC::EncodedJSValue jsResizeObserverPrototypeFunction_disconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSResizeObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsResizeObserverPrototypeFunction_disconnect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSResizeObserver>::call<jsResizeObserverPrototypeFunction_disconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

JSC::GCClient::IsoSubspace* JSResizeObserver::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSResizeObserver, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForResizeObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForResizeObserver = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForResizeObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForResizeObserver = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSResizeObserver::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSResizeObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSResizeObserver);

template<typename Visitor>
void JSResizeObserver::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSResizeObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSResizeObserver::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSResizeObserver::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSResizeObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSResizeObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSResizeObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsResizeObserver = static_cast<JSResizeObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsResizeObserver->wrapped(), jsResizeObserver);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ResizeObserver@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14ResizeObserverE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ResizeObserver>&& impl)
{

    if constexpr (std::is_polymorphic_v<ResizeObserver>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ResizeObserver@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14ResizeObserverE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ResizeObserver has subclasses. If ResizeObserver has subclasses that get passed
        // to toJS() we currently require ResizeObserver you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<ResizeObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ResizeObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ResizeObserver* JSResizeObserver::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSResizeObserver*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
