/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(NOTIFICATIONS)

#include "JSNotificationOptions.h"

#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSNotificationDirection.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(NOTIFICATIONS)

template<> NotificationOptions convertDictionary<NotificationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    NotificationOptions result;
    JSValue bodyValue;
    if (isNullOrUndefined)
        bodyValue = jsUndefined();
    else {
        bodyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "body"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bodyValue.isUndefined()) {
        result.body = convert<IDLDOMString>(lexicalGlobalObject, bodyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.body = emptyString();
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dataValue.isUndefined()) {
        result.data = convert<IDLAny>(lexicalGlobalObject, dataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.data = jsNull();
    JSValue dirValue;
    if (isNullOrUndefined)
        dirValue = jsUndefined();
    else {
        dirValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dir"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dirValue.isUndefined()) {
        result.dir = convert<IDLEnumeration<NotificationDirection>>(lexicalGlobalObject, dirValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.dir = NotificationDirection::Auto;
    JSValue iconValue;
    if (isNullOrUndefined)
        iconValue = jsUndefined();
    else {
        iconValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "icon"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iconValue.isUndefined()) {
        result.icon = convert<IDLUSVString>(lexicalGlobalObject, iconValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue langValue;
    if (isNullOrUndefined)
        langValue = jsUndefined();
    else {
        langValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lang"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!langValue.isUndefined()) {
        result.lang = convert<IDLDOMString>(lexicalGlobalObject, langValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.lang = emptyString();
    JSValue silentValue;
    if (isNullOrUndefined)
        silentValue = jsUndefined();
    else {
        silentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "silent"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!silentValue.isUndefined()) {
        result.silent = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, silentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.silent = std::nullopt;
    JSValue tagValue;
    if (isNullOrUndefined)
        tagValue = jsUndefined();
    else {
        tagValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tag"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tagValue.isUndefined()) {
        result.tag = convert<IDLDOMString>(lexicalGlobalObject, tagValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tag = emptyString();
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(NOTIFICATIONS)
