/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageBitmapOptions.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

template<> ImageBitmapOptions convertDictionary<ImageBitmapOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ImageBitmapOptions result;
    JSValue colorSpaceConversionValue;
    if (isNullOrUndefined)
        colorSpaceConversionValue = jsUndefined();
    else {
        colorSpaceConversionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpaceConversion"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorSpaceConversionValue.isUndefined()) {
        result.colorSpaceConversion = convert<IDLEnumeration<ImageBitmapOptions::ColorSpaceConversion>>(lexicalGlobalObject, colorSpaceConversionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.colorSpaceConversion = ImageBitmapOptions::ColorSpaceConversion::Default;
    JSValue imageOrientationValue;
    if (isNullOrUndefined)
        imageOrientationValue = jsUndefined();
    else {
        imageOrientationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "imageOrientation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!imageOrientationValue.isUndefined()) {
        result.orientation = convert<IDLEnumeration<ImageBitmapOptions::Orientation>>(lexicalGlobalObject, imageOrientationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.orientation = ImageBitmapOptions::Orientation::None;
    JSValue premultiplyAlphaValue;
    if (isNullOrUndefined)
        premultiplyAlphaValue = jsUndefined();
    else {
        premultiplyAlphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "premultiplyAlpha"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!premultiplyAlphaValue.isUndefined()) {
        result.premultiplyAlpha = convert<IDLEnumeration<ImageBitmapOptions::PremultiplyAlpha>>(lexicalGlobalObject, premultiplyAlphaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.premultiplyAlpha = ImageBitmapOptions::PremultiplyAlpha::Default;
    JSValue resizeHeightValue;
    if (isNullOrUndefined)
        resizeHeightValue = jsUndefined();
    else {
        resizeHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resizeHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!resizeHeightValue.isUndefined()) {
        result.resizeHeight = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, resizeHeightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue resizeQualityValue;
    if (isNullOrUndefined)
        resizeQualityValue = jsUndefined();
    else {
        resizeQualityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resizeQuality"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!resizeQualityValue.isUndefined()) {
        result.resizeQuality = convert<IDLEnumeration<ImageBitmapOptions::ResizeQuality>>(lexicalGlobalObject, resizeQualityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.resizeQuality = ImageBitmapOptions::ResizeQuality::Low;
    JSValue resizeWidthValue;
    if (isNullOrUndefined)
        resizeWidthValue = jsUndefined();
    else {
        resizeWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resizeWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!resizeWidthValue.isUndefined()) {
        result.resizeWidth = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, resizeWidthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

String convertEnumerationToString(ImageBitmapOptions::Orientation enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("flipY"),
    };
    static_assert(static_cast<size_t>(ImageBitmapOptions::Orientation::None) == 0, "ImageBitmapOptions::Orientation::None is not 0 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::Orientation::FlipY) == 1, "ImageBitmapOptions::Orientation::FlipY is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageBitmapOptions::Orientation enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageBitmapOptions::Orientation> parseEnumerationFromString<ImageBitmapOptions::Orientation>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ImageBitmapOptions::Orientation> mappings[] = {
        { "flipY", ImageBitmapOptions::Orientation::FlipY },
        { "none", ImageBitmapOptions::Orientation::None },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageBitmapOptions::Orientation> parseEnumeration<ImageBitmapOptions::Orientation>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageBitmapOptions::Orientation>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ImageBitmapOptions::Orientation>()
{
    return "\"none\", \"flipY\"";
}

String convertEnumerationToString(ImageBitmapOptions::PremultiplyAlpha enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("premultiply"),
        MAKE_STATIC_STRING_IMPL("default"),
    };
    static_assert(static_cast<size_t>(ImageBitmapOptions::PremultiplyAlpha::None) == 0, "ImageBitmapOptions::PremultiplyAlpha::None is not 0 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::PremultiplyAlpha::Premultiply) == 1, "ImageBitmapOptions::PremultiplyAlpha::Premultiply is not 1 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::PremultiplyAlpha::Default) == 2, "ImageBitmapOptions::PremultiplyAlpha::Default is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageBitmapOptions::PremultiplyAlpha enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageBitmapOptions::PremultiplyAlpha> parseEnumerationFromString<ImageBitmapOptions::PremultiplyAlpha>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ImageBitmapOptions::PremultiplyAlpha> mappings[] = {
        { "default", ImageBitmapOptions::PremultiplyAlpha::Default },
        { "none", ImageBitmapOptions::PremultiplyAlpha::None },
        { "premultiply", ImageBitmapOptions::PremultiplyAlpha::Premultiply },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageBitmapOptions::PremultiplyAlpha> parseEnumeration<ImageBitmapOptions::PremultiplyAlpha>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageBitmapOptions::PremultiplyAlpha>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ImageBitmapOptions::PremultiplyAlpha>()
{
    return "\"none\", \"premultiply\", \"default\"";
}

String convertEnumerationToString(ImageBitmapOptions::ColorSpaceConversion enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("default"),
    };
    static_assert(static_cast<size_t>(ImageBitmapOptions::ColorSpaceConversion::None) == 0, "ImageBitmapOptions::ColorSpaceConversion::None is not 0 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::ColorSpaceConversion::Default) == 1, "ImageBitmapOptions::ColorSpaceConversion::Default is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageBitmapOptions::ColorSpaceConversion enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageBitmapOptions::ColorSpaceConversion> parseEnumerationFromString<ImageBitmapOptions::ColorSpaceConversion>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ImageBitmapOptions::ColorSpaceConversion> mappings[] = {
        { "default", ImageBitmapOptions::ColorSpaceConversion::Default },
        { "none", ImageBitmapOptions::ColorSpaceConversion::None },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageBitmapOptions::ColorSpaceConversion> parseEnumeration<ImageBitmapOptions::ColorSpaceConversion>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageBitmapOptions::ColorSpaceConversion>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ImageBitmapOptions::ColorSpaceConversion>()
{
    return "\"none\", \"default\"";
}

String convertEnumerationToString(ImageBitmapOptions::ResizeQuality enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("pixelated"),
        MAKE_STATIC_STRING_IMPL("low"),
        MAKE_STATIC_STRING_IMPL("medium"),
        MAKE_STATIC_STRING_IMPL("high"),
    };
    static_assert(static_cast<size_t>(ImageBitmapOptions::ResizeQuality::Pixelated) == 0, "ImageBitmapOptions::ResizeQuality::Pixelated is not 0 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::ResizeQuality::Low) == 1, "ImageBitmapOptions::ResizeQuality::Low is not 1 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::ResizeQuality::Medium) == 2, "ImageBitmapOptions::ResizeQuality::Medium is not 2 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::ResizeQuality::High) == 3, "ImageBitmapOptions::ResizeQuality::High is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageBitmapOptions::ResizeQuality enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageBitmapOptions::ResizeQuality> parseEnumerationFromString<ImageBitmapOptions::ResizeQuality>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ImageBitmapOptions::ResizeQuality> mappings[] = {
        { "high", ImageBitmapOptions::ResizeQuality::High },
        { "low", ImageBitmapOptions::ResizeQuality::Low },
        { "medium", ImageBitmapOptions::ResizeQuality::Medium },
        { "pixelated", ImageBitmapOptions::ResizeQuality::Pixelated },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageBitmapOptions::ResizeQuality> parseEnumeration<ImageBitmapOptions::ResizeQuality>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageBitmapOptions::ResizeQuality>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ImageBitmapOptions::ResizeQuality>()
{
    return "\"pixelated\", \"low\", \"medium\", \"high\"";
}

} // namespace WebCore
