/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPipeline.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUBindGroupLayout.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPipelinePrototypeFunction_getBindGroupLayout);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPURenderPipelineConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPURenderPipeline_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPURenderPipeline_label);

class JSGPURenderPipelinePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPURenderPipelinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPURenderPipelinePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPURenderPipelinePrototype>(vm)) JSGPURenderPipelinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPURenderPipelinePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPURenderPipelinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPURenderPipelinePrototype, JSGPURenderPipelinePrototype::Base);

using JSGPURenderPipelineDOMConstructor = JSDOMConstructorNotConstructable<JSGPURenderPipeline>;

template<> const ClassInfo JSGPURenderPipelineDOMConstructor::s_info = { "GPURenderPipeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderPipelineDOMConstructor) };

template<> JSValue JSGPURenderPipelineDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPURenderPipelineDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPURenderPipeline"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPURenderPipeline::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPURenderPipelinePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPURenderPipelineConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPURenderPipeline_label, setJSGPURenderPipeline_label } },
    { "getBindGroupLayout"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPipelinePrototypeFunction_getBindGroupLayout, 1 } },
};

const ClassInfo JSGPURenderPipelinePrototype::s_info = { "GPURenderPipeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderPipelinePrototype) };

void JSGPURenderPipelinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPURenderPipeline::info(), JSGPURenderPipelinePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "getBindGroupLayout"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPURenderPipeline::s_info = { "GPURenderPipeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderPipeline) };

JSGPURenderPipeline::JSGPURenderPipeline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPURenderPipeline>&& impl)
    : JSDOMWrapper<GPURenderPipeline>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPURenderPipeline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPURenderPipeline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPURenderPipelinePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPURenderPipelinePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPURenderPipeline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPURenderPipeline>(vm, globalObject);
}

JSValue JSGPURenderPipeline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPURenderPipelineDOMConstructor, DOMConstructorID::GPURenderPipeline>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPURenderPipeline::destroy(JSC::JSCell* cell)
{
    JSGPURenderPipeline* thisObject = static_cast<JSGPURenderPipeline*>(cell);
    thisObject->JSGPURenderPipeline::~JSGPURenderPipeline();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPURenderPipelineConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPURenderPipelinePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPURenderPipeline::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPURenderPipeline_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPURenderPipeline& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPURenderPipeline_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPURenderPipeline>::get<jsGPURenderPipeline_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPURenderPipeline_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPURenderPipeline& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPURenderPipeline_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPURenderPipeline>::set<setJSGPURenderPipeline_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPURenderPipelinePrototypeFunction_getBindGroupLayoutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPipeline>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUBindGroupLayout>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getBindGroupLayout(WTFMove(index)))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPipelinePrototypeFunction_getBindGroupLayout, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPipeline>::call<jsGPURenderPipelinePrototypeFunction_getBindGroupLayoutBody>(*lexicalGlobalObject, *callFrame, "getBindGroupLayout");
}

JSC::GCClient::IsoSubspace* JSGPURenderPipeline::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPURenderPipeline, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPURenderPipeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPURenderPipeline = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPURenderPipeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPURenderPipeline = std::forward<decltype(space)>(space); }
    );
}

void JSGPURenderPipeline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPURenderPipeline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPURenderPipelineOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPURenderPipelineOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPURenderPipeline = static_cast<JSGPURenderPipeline*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPURenderPipeline->wrapped(), jsGPURenderPipeline);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPURenderPipeline@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17GPURenderPipelineE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPURenderPipeline>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPURenderPipeline>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPURenderPipeline@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17GPURenderPipelineE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPURenderPipeline has subclasses. If GPURenderPipeline has subclasses that get passed
        // to toJS() we currently require GPURenderPipeline you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPURenderPipeline>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPURenderPipeline& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPURenderPipeline* JSGPURenderPipeline::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPURenderPipeline*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
