/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassColorAttachment.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUColorDict.h"
#include "JSGPULoadOp.h"
#include "JSGPUStoreOp.h"
#include "JSGPUTextureView.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> GPURenderPassColorAttachment convertDictionary<GPURenderPassColorAttachment>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPURenderPassColorAttachment result;
    JSValue clearValueValue;
    if (isNullOrUndefined)
        clearValueValue = jsUndefined();
    else {
        clearValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clearValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clearValueValue.isUndefined()) {
        result.clearValue = convert<IDLUnion<IDLSequence<IDLDouble>, IDLDictionary<GPUColorDict>>>(lexicalGlobalObject, clearValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue loadOpValue;
    if (isNullOrUndefined)
        loadOpValue = jsUndefined();
    else {
        loadOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loadOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!loadOpValue.isUndefined()) {
        result.loadOp = convert<IDLEnumeration<GPULoadOp>>(lexicalGlobalObject, loadOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "loadOp", "GPURenderPassColorAttachment", "GPULoadOp");
        return { };
    }
    JSValue resolveTargetValue;
    if (isNullOrUndefined)
        resolveTargetValue = jsUndefined();
    else {
        resolveTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resolveTarget"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!resolveTargetValue.isUndefined()) {
        result.resolveTarget = convert<IDLInterface<GPUTextureView>>(lexicalGlobalObject, resolveTargetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue storeOpValue;
    if (isNullOrUndefined)
        storeOpValue = jsUndefined();
    else {
        storeOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "storeOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!storeOpValue.isUndefined()) {
        result.storeOp = convert<IDLEnumeration<GPUStoreOp>>(lexicalGlobalObject, storeOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "storeOp", "GPURenderPassColorAttachment", "GPUStoreOp");
        return { };
    }
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLInterface<GPUTextureView>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "view", "GPURenderPassColorAttachment", "GPUTextureView");
        return { };
    }
    return result;
}

} // namespace WebCore
