/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUPrimitiveState.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSGPUCullMode.h"
#include "JSGPUFrontFace.h"
#include "JSGPUIndexFormat.h"
#include "JSGPUPrimitiveTopology.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUPrimitiveState convertDictionary<GPUPrimitiveState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUPrimitiveState result;
    JSValue cullModeValue;
    if (isNullOrUndefined)
        cullModeValue = jsUndefined();
    else {
        cullModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cullMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cullModeValue.isUndefined()) {
        result.cullMode = convert<IDLEnumeration<GPUCullMode>>(lexicalGlobalObject, cullModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cullMode = GPUCullMode::None;
    JSValue frontFaceValue;
    if (isNullOrUndefined)
        frontFaceValue = jsUndefined();
    else {
        frontFaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frontFace"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frontFaceValue.isUndefined()) {
        result.frontFace = convert<IDLEnumeration<GPUFrontFace>>(lexicalGlobalObject, frontFaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.frontFace = GPUFrontFace::Ccw;
    JSValue stripIndexFormatValue;
    if (isNullOrUndefined)
        stripIndexFormatValue = jsUndefined();
    else {
        stripIndexFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stripIndexFormat"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stripIndexFormatValue.isUndefined()) {
        result.stripIndexFormat = convert<IDLEnumeration<GPUIndexFormat>>(lexicalGlobalObject, stripIndexFormatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue topologyValue;
    if (isNullOrUndefined)
        topologyValue = jsUndefined();
    else {
        topologyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "topology"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!topologyValue.isUndefined()) {
        result.topology = convert<IDLEnumeration<GPUPrimitiveTopology>>(lexicalGlobalObject, topologyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.topology = GPUPrimitiveTopology::TriangleList;
    JSValue unclippedDepthValue;
    if (isNullOrUndefined)
        unclippedDepthValue = jsUndefined();
    else {
        unclippedDepthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "unclippedDepth"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!unclippedDepthValue.isUndefined()) {
        result.unclippedDepth = convert<IDLBoolean>(lexicalGlobalObject, unclippedDepthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.unclippedDepth = false;
    return result;
}

} // namespace WebCore
