/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUColorTargetState.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSGPUBlendState.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUColorTargetState convertDictionary<GPUColorTargetState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUColorTargetState result;
    JSValue blendValue;
    if (isNullOrUndefined)
        blendValue = jsUndefined();
    else {
        blendValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "blend"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!blendValue.isUndefined()) {
        result.blend = convert<IDLDictionary<GPUBlendState>>(lexicalGlobalObject, blendValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "GPUColorTargetState", "GPUTextureFormat");
        return { };
    }
    JSValue writeMaskValue;
    if (isNullOrUndefined)
        writeMaskValue = jsUndefined();
    else {
        writeMaskValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "writeMask"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!writeMaskValue.isUndefined()) {
        result.writeMask = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, writeMaskValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.writeMask = 0xF;
    return result;
}

} // namespace WebCore
