/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequestCredentials.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchRequestCredentials enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("omit"),
        MAKE_STATIC_STRING_IMPL("same-origin"),
        MAKE_STATIC_STRING_IMPL("include"),
    };
    static_assert(static_cast<size_t>(FetchRequestCredentials::Omit) == 0, "FetchRequestCredentials::Omit is not 0 as expected");
    static_assert(static_cast<size_t>(FetchRequestCredentials::SameOrigin) == 1, "FetchRequestCredentials::SameOrigin is not 1 as expected");
    static_assert(static_cast<size_t>(FetchRequestCredentials::Include) == 2, "FetchRequestCredentials::Include is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FetchRequestCredentials enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FetchRequestCredentials> parseEnumerationFromString<FetchRequestCredentials>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, FetchRequestCredentials> mappings[] = {
        { "include", FetchRequestCredentials::Include },
        { "omit", FetchRequestCredentials::Omit },
        { "same-origin", FetchRequestCredentials::SameOrigin },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FetchRequestCredentials> parseEnumeration<FetchRequestCredentials>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FetchRequestCredentials>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<FetchRequestCredentials>()
{
    return "\"omit\", \"same-origin\", \"include\"";
}

} // namespace WebCore
