/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocumentTimeline.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCustomAnimationOptions.h"
#include "JSCustomEffectCallback.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocumentTimelineOptions.h"
#include "JSWebAnimation.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDocumentTimelinePrototypeFunction_animate);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDocumentTimelineConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDocumentTimeline_maximumFrameRate);

class JSDocumentTimelinePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDocumentTimelinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDocumentTimelinePrototype* ptr = new (NotNull, JSC::allocateCell<JSDocumentTimelinePrototype>(vm)) JSDocumentTimelinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDocumentTimelinePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDocumentTimelinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDocumentTimelinePrototype, JSDocumentTimelinePrototype::Base);

using JSDocumentTimelineDOMConstructor = JSDOMConstructor<JSDocumentTimeline>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDocumentTimelineDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDocumentTimelineDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "DocumentTimeline");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<DocumentTimelineOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DocumentTimeline::create(document, WTFMove(options));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DocumentTimeline>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DocumentTimeline>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDocumentTimelineDOMConstructorConstruct, JSDocumentTimelineDOMConstructor::construct);

template<> const ClassInfo JSDocumentTimelineDOMConstructor::s_info = { "DocumentTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentTimelineDOMConstructor) };

template<> JSValue JSDocumentTimelineDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAnimationTimeline::getConstructor(vm, &globalObject);
}

template<> void JSDocumentTimelineDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DocumentTimeline"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDocumentTimeline::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDocumentTimelinePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDocumentTimelineConstructor, 0 } },
    { "maximumFrameRate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDocumentTimeline_maximumFrameRate, 0 } },
    { "animate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDocumentTimelinePrototypeFunction_animate, 1 } },
};

const ClassInfo JSDocumentTimelinePrototype::s_info = { "DocumentTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentTimelinePrototype) };

void JSDocumentTimelinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDocumentTimeline::info(), JSDocumentTimelinePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().webAnimationsCustomEffectsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animate"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().webAnimationsCustomFrameRateEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "maximumFrameRate"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDocumentTimeline::s_info = { "DocumentTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentTimeline) };

JSDocumentTimeline::JSDocumentTimeline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DocumentTimeline>&& impl)
    : JSAnimationTimeline(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DocumentTimeline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDocumentTimeline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDocumentTimelinePrototype::createStructure(vm, &globalObject, JSAnimationTimeline::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSDocumentTimelinePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDocumentTimeline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDocumentTimeline>(vm, globalObject);
}

JSValue JSDocumentTimeline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentTimelineDOMConstructor, DOMConstructorID::DocumentTimeline>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocumentTimelineConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDocumentTimelinePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDocumentTimeline::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsDocumentTimeline_maximumFrameRateGetter(JSGlobalObject& lexicalGlobalObject, JSDocumentTimeline& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.maximumFrameRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDocumentTimeline_maximumFrameRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDocumentTimeline>::get<jsDocumentTimeline_maximumFrameRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDocumentTimelinePrototypeFunction_animateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocumentTimeline>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callback = convert<IDLCallbackFunction<JSCustomEffectCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "DocumentTimeline", "animate"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = argument1.value().isUndefined() ? std::optional<Converter<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<CustomAnimationOptions>>>::ReturnType>() : std::optional<Converter<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<CustomAnimationOptions>>>::ReturnType>(convert<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<CustomAnimationOptions>>>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<WebAnimation>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.animate(callback.releaseNonNull(), WTFMove(options)))));
}

JSC_DEFINE_HOST_FUNCTION(jsDocumentTimelinePrototypeFunction_animate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDocumentTimeline>::call<jsDocumentTimelinePrototypeFunction_animateBody>(*lexicalGlobalObject, *callFrame, "animate");
}

JSC::GCClient::IsoSubspace* JSDocumentTimeline::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDocumentTimeline, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDocumentTimeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDocumentTimeline = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDocumentTimeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDocumentTimeline = std::forward<decltype(space)>(space); }
    );
}

void JSDocumentTimeline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDocumentTimeline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DocumentTimeline@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16DocumentTimelineE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DocumentTimeline>&& impl)
{

    if constexpr (std::is_polymorphic_v<DocumentTimeline>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DocumentTimeline@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16DocumentTimelineE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DocumentTimeline has subclasses. If DocumentTimeline has subclasses that get passed
        // to toJS() we currently require DocumentTimeline you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<DocumentTimeline>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DocumentTimeline& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
