/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSDelayOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> DelayOptions convertDictionary<DelayOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    DelayOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountValue.isUndefined()) {
        result.channelCount = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountModeValue.isUndefined()) {
        result.channelCountMode = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        result.channelInterpretation = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue delayTimeValue;
    if (isNullOrUndefined)
        delayTimeValue = jsUndefined();
    else {
        delayTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delayTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!delayTimeValue.isUndefined()) {
        result.delayTime = convert<IDLDouble>(lexicalGlobalObject, delayTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.delayTime = 0;
    JSValue maxDelayTimeValue;
    if (isNullOrUndefined)
        maxDelayTimeValue = jsUndefined();
    else {
        maxDelayTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxDelayTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxDelayTimeValue.isUndefined()) {
        result.maxDelayTime = convert<IDLDouble>(lexicalGlobalObject, maxDelayTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.maxDelayTime = 1;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
