/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDataTransferItem.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSFile.h"
#include "JSFileSystemEntry.h"
#include "JSStringCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDataTransferItemPrototypeFunction_getAsString);
static JSC_DECLARE_HOST_FUNCTION(jsDataTransferItemPrototypeFunction_getAsFile);
static JSC_DECLARE_HOST_FUNCTION(jsDataTransferItemPrototypeFunction_webkitGetAsEntry);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDataTransferItemConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDataTransferItem_kind);
static JSC_DECLARE_CUSTOM_GETTER(jsDataTransferItem_type);

class JSDataTransferItemPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDataTransferItemPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDataTransferItemPrototype* ptr = new (NotNull, JSC::allocateCell<JSDataTransferItemPrototype>(vm)) JSDataTransferItemPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDataTransferItemPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDataTransferItemPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDataTransferItemPrototype, JSDataTransferItemPrototype::Base);

using JSDataTransferItemDOMConstructor = JSDOMConstructorNotConstructable<JSDataTransferItem>;

template<> const ClassInfo JSDataTransferItemDOMConstructor::s_info = { "DataTransferItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDataTransferItemDOMConstructor) };

template<> JSValue JSDataTransferItemDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDataTransferItemDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DataTransferItem"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDataTransferItem::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDataTransferItemPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDataTransferItemConstructor, 0 } },
    { "kind"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDataTransferItem_kind, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDataTransferItem_type, 0 } },
    { "getAsString"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDataTransferItemPrototypeFunction_getAsString, 1 } },
    { "getAsFile"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDataTransferItemPrototypeFunction_getAsFile, 0 } },
    { "webkitGetAsEntry"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDataTransferItemPrototypeFunction_webkitGetAsEntry, 0 } },
};

const ClassInfo JSDataTransferItemPrototype::s_info = { "DataTransferItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDataTransferItemPrototype) };

void JSDataTransferItemPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDataTransferItem::info(), JSDataTransferItemPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDataTransferItem::s_info = { "DataTransferItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDataTransferItem) };

JSDataTransferItem::JSDataTransferItem(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DataTransferItem>&& impl)
    : JSDOMWrapper<DataTransferItem>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DataTransferItem>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDataTransferItem::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDataTransferItemPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDataTransferItemPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDataTransferItem::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDataTransferItem>(vm, globalObject);
}

JSValue JSDataTransferItem::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDataTransferItemDOMConstructor, DOMConstructorID::DataTransferItem>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDataTransferItem::destroy(JSC::JSCell* cell)
{
    JSDataTransferItem* thisObject = static_cast<JSDataTransferItem*>(cell);
    thisObject->JSDataTransferItem::~JSDataTransferItem();
}

JSC_DEFINE_CUSTOM_GETTER(jsDataTransferItemConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDataTransferItemPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDataTransferItem::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsDataTransferItem_kindGetter(JSGlobalObject& lexicalGlobalObject, JSDataTransferItem& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.kind())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDataTransferItem_kind, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDataTransferItem>::get<jsDataTransferItem_kindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDataTransferItem_typeGetter(JSGlobalObject& lexicalGlobalObject, JSDataTransferItem& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDataTransferItem_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDataTransferItem>::get<jsDataTransferItem_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDataTransferItemPrototypeFunction_getAsStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDataTransferItem>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callback = convert<IDLNullable<IDLCallbackFunction<JSStringCallback>>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "DataTransferItem", "getAsString"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.getAsString(document, WTFMove(callback)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsDataTransferItemPrototypeFunction_getAsString, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDataTransferItem>::call<jsDataTransferItemPrototypeFunction_getAsStringBody>(*lexicalGlobalObject, *callFrame, "getAsString");
}

static inline JSC::EncodedJSValue jsDataTransferItemPrototypeFunction_getAsFileBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDataTransferItem>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<File>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAsFile())));
}

JSC_DEFINE_HOST_FUNCTION(jsDataTransferItemPrototypeFunction_getAsFile, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDataTransferItem>::call<jsDataTransferItemPrototypeFunction_getAsFileBody>(*lexicalGlobalObject, *callFrame, "getAsFile");
}

static inline JSC::EncodedJSValue jsDataTransferItemPrototypeFunction_webkitGetAsEntryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDataTransferItem>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<FileSystemEntry>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAsEntry(*context))));
}

JSC_DEFINE_HOST_FUNCTION(jsDataTransferItemPrototypeFunction_webkitGetAsEntry, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDataTransferItem>::call<jsDataTransferItemPrototypeFunction_webkitGetAsEntryBody>(*lexicalGlobalObject, *callFrame, "webkitGetAsEntry");
}

JSC::GCClient::IsoSubspace* JSDataTransferItem::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDataTransferItem, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDataTransferItem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDataTransferItem = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDataTransferItem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDataTransferItem = std::forward<decltype(space)>(space); }
    );
}

void JSDataTransferItem::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDataTransferItem*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDataTransferItemOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDataTransferItemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDataTransferItem = static_cast<JSDataTransferItem*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDataTransferItem->wrapped(), jsDataTransferItem);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DataTransferItem@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16DataTransferItemE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DataTransferItem>&& impl)
{

    if constexpr (std::is_polymorphic_v<DataTransferItem>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DataTransferItem@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16DataTransferItemE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DataTransferItem has subclasses. If DataTransferItem has subclasses that get passed
        // to toJS() we currently require DataTransferItem you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<DataTransferItem>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DataTransferItem& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DataTransferItem* JSDataTransferItem::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDataTransferItem*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
