/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasFillRule.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CanvasFillRule enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("nonzero"),
        MAKE_STATIC_STRING_IMPL("evenodd"),
    };
    static_assert(static_cast<size_t>(CanvasFillRule::Nonzero) == 0, "CanvasFillRule::Nonzero is not 0 as expected");
    static_assert(static_cast<size_t>(CanvasFillRule::Evenodd) == 1, "CanvasFillRule::Evenodd is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CanvasFillRule enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CanvasFillRule> parseEnumerationFromString<CanvasFillRule>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, CanvasFillRule> mappings[] = {
        { "evenodd", CanvasFillRule::Evenodd },
        { "nonzero", CanvasFillRule::Nonzero },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CanvasFillRule> parseEnumeration<CanvasFillRule>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CanvasFillRule>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<CanvasFillRule>()
{
    return "\"nonzero\", \"evenodd\"";
}

} // namespace WebCore
