/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSNumericType.h"

#include "JSCSSNumericBaseType.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> CSSNumericType convertDictionary<CSSNumericType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CSSNumericType result;
    JSValue angleValue;
    if (isNullOrUndefined)
        angleValue = jsUndefined();
    else {
        angleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "angle"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!angleValue.isUndefined()) {
        result.angle = convert<IDLLong>(lexicalGlobalObject, angleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue flexValue;
    if (isNullOrUndefined)
        flexValue = jsUndefined();
    else {
        flexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "flex"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!flexValue.isUndefined()) {
        result.flex = convert<IDLLong>(lexicalGlobalObject, flexValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frequencyValue;
    if (isNullOrUndefined)
        frequencyValue = jsUndefined();
    else {
        frequencyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frequency"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frequencyValue.isUndefined()) {
        result.frequency = convert<IDLLong>(lexicalGlobalObject, frequencyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue lengthValue;
    if (isNullOrUndefined)
        lengthValue = jsUndefined();
    else {
        lengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "length"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!lengthValue.isUndefined()) {
        result.length = convert<IDLLong>(lexicalGlobalObject, lengthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue percentValue;
    if (isNullOrUndefined)
        percentValue = jsUndefined();
    else {
        percentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "percent"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!percentValue.isUndefined()) {
        result.percent = convert<IDLLong>(lexicalGlobalObject, percentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue percentHintValue;
    if (isNullOrUndefined)
        percentHintValue = jsUndefined();
    else {
        percentHintValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "percentHint"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!percentHintValue.isUndefined()) {
        result.percentHint = convert<IDLEnumeration<CSSNumericBaseType>>(lexicalGlobalObject, percentHintValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue resolutionValue;
    if (isNullOrUndefined)
        resolutionValue = jsUndefined();
    else {
        resolutionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resolution"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!resolutionValue.isUndefined()) {
        result.resolution = convert<IDLLong>(lexicalGlobalObject, resolutionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue timeValue;
    if (isNullOrUndefined)
        timeValue = jsUndefined();
    else {
        timeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "time"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timeValue.isUndefined()) {
        result.time = convert<IDLLong>(lexicalGlobalObject, timeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CSSNumericType& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLLong::isNullValue(dictionary.angle)) {
        auto angleValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.angle));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "angle"_s), angleValue);
    }
    if (!IDLLong::isNullValue(dictionary.flex)) {
        auto flexValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.flex));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "flex"_s), flexValue);
    }
    if (!IDLLong::isNullValue(dictionary.frequency)) {
        auto frequencyValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.frequency));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frequency"_s), frequencyValue);
    }
    if (!IDLLong::isNullValue(dictionary.length)) {
        auto lengthValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.length));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "length"_s), lengthValue);
    }
    if (!IDLLong::isNullValue(dictionary.percent)) {
        auto percentValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.percent));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "percent"_s), percentValue);
    }
    if (!IDLEnumeration<CSSNumericBaseType>::isNullValue(dictionary.percentHint)) {
        auto percentHintValue = toJS<IDLEnumeration<CSSNumericBaseType>>(lexicalGlobalObject, throwScope, IDLEnumeration<CSSNumericBaseType>::extractValueFromNullable(dictionary.percentHint));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "percentHint"_s), percentHintValue);
    }
    if (!IDLLong::isNullValue(dictionary.resolution)) {
        auto resolutionValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.resolution));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "resolution"_s), resolutionValue);
    }
    if (!IDLLong::isNullValue(dictionary.time)) {
        auto timeValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.time));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "time"_s), timeValue);
    }
    return result;
}

} // namespace WebCore
