/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSMathOperator.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CSSMathOperator enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("sum"),
        MAKE_STATIC_STRING_IMPL("product"),
        MAKE_STATIC_STRING_IMPL("negate"),
        MAKE_STATIC_STRING_IMPL("invert"),
        MAKE_STATIC_STRING_IMPL("min"),
        MAKE_STATIC_STRING_IMPL("max"),
        MAKE_STATIC_STRING_IMPL("clamp"),
    };
    static_assert(static_cast<size_t>(CSSMathOperator::Sum) == 0, "CSSMathOperator::Sum is not 0 as expected");
    static_assert(static_cast<size_t>(CSSMathOperator::Product) == 1, "CSSMathOperator::Product is not 1 as expected");
    static_assert(static_cast<size_t>(CSSMathOperator::Negate) == 2, "CSSMathOperator::Negate is not 2 as expected");
    static_assert(static_cast<size_t>(CSSMathOperator::Invert) == 3, "CSSMathOperator::Invert is not 3 as expected");
    static_assert(static_cast<size_t>(CSSMathOperator::Min) == 4, "CSSMathOperator::Min is not 4 as expected");
    static_assert(static_cast<size_t>(CSSMathOperator::Max) == 5, "CSSMathOperator::Max is not 5 as expected");
    static_assert(static_cast<size_t>(CSSMathOperator::Clamp) == 6, "CSSMathOperator::Clamp is not 6 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CSSMathOperator enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CSSMathOperator> parseEnumerationFromString<CSSMathOperator>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, CSSMathOperator> mappings[] = {
        { "clamp", CSSMathOperator::Clamp },
        { "invert", CSSMathOperator::Invert },
        { "max", CSSMathOperator::Max },
        { "min", CSSMathOperator::Min },
        { "negate", CSSMathOperator::Negate },
        { "product", CSSMathOperator::Product },
        { "sum", CSSMathOperator::Sum },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CSSMathOperator> parseEnumeration<CSSMathOperator>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CSSMathOperator>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<CSSMathOperator>()
{
    return "\"sum\", \"product\", \"negate\", \"invert\", \"min\", \"max\", \"clamp\"";
}

} // namespace WebCore
