/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioWorkletNodeOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> AudioWorkletNodeOptions convertDictionary<AudioWorkletNodeOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AudioWorkletNodeOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountValue.isUndefined()) {
        result.channelCount = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelCountModeValue.isUndefined()) {
        result.channelCountMode = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        result.channelInterpretation = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue numberOfInputsValue;
    if (isNullOrUndefined)
        numberOfInputsValue = jsUndefined();
    else {
        numberOfInputsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numberOfInputs"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!numberOfInputsValue.isUndefined()) {
        result.numberOfInputs = convert<IDLUnsignedLong>(lexicalGlobalObject, numberOfInputsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.numberOfInputs = 1;
    JSValue numberOfOutputsValue;
    if (isNullOrUndefined)
        numberOfOutputsValue = jsUndefined();
    else {
        numberOfOutputsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "numberOfOutputs"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!numberOfOutputsValue.isUndefined()) {
        result.numberOfOutputs = convert<IDLUnsignedLong>(lexicalGlobalObject, numberOfOutputsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.numberOfOutputs = 1;
    JSValue outputChannelCountValue;
    if (isNullOrUndefined)
        outputChannelCountValue = jsUndefined();
    else {
        outputChannelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "outputChannelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!outputChannelCountValue.isUndefined()) {
        result.outputChannelCount = convert<IDLSequence<IDLUnsignedLong>>(lexicalGlobalObject, outputChannelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue parameterDataValue;
    if (isNullOrUndefined)
        parameterDataValue = jsUndefined();
    else {
        parameterDataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "parameterData"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!parameterDataValue.isUndefined()) {
        result.parameterData = convert<IDLRecord<IDLDOMString, IDLDouble>>(lexicalGlobalObject, parameterDataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue processorOptionsValue;
    if (isNullOrUndefined)
        processorOptionsValue = jsUndefined();
    else {
        processorOptionsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "processorOptions"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!processorOptionsValue.isUndefined()) {
        result.processorOptions = convert<IDLObject>(lexicalGlobalObject, processorOptionsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const AudioWorkletNodeOptions& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnsignedLong::isNullValue(dictionary.channelCount)) {
        auto channelCountValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, IDLUnsignedLong::extractValueFromNullable(dictionary.channelCount));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "channelCount"_s), channelCountValue);
    }
    if (!IDLEnumeration<ChannelCountMode>::isNullValue(dictionary.channelCountMode)) {
        auto channelCountModeValue = toJS<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, throwScope, IDLEnumeration<ChannelCountMode>::extractValueFromNullable(dictionary.channelCountMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "channelCountMode"_s), channelCountModeValue);
    }
    if (!IDLEnumeration<ChannelInterpretation>::isNullValue(dictionary.channelInterpretation)) {
        auto channelInterpretationValue = toJS<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, throwScope, IDLEnumeration<ChannelInterpretation>::extractValueFromNullable(dictionary.channelInterpretation));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "channelInterpretation"_s), channelInterpretationValue);
    }
    auto numberOfInputsValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.numberOfInputs);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "numberOfInputs"_s), numberOfInputsValue);
    auto numberOfOutputsValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, dictionary.numberOfOutputs);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "numberOfOutputs"_s), numberOfOutputsValue);
    if (!IDLSequence<IDLUnsignedLong>::isNullValue(dictionary.outputChannelCount)) {
        auto outputChannelCountValue = toJS<IDLSequence<IDLUnsignedLong>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLUnsignedLong>::extractValueFromNullable(dictionary.outputChannelCount));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "outputChannelCount"_s), outputChannelCountValue);
    }
    if (!IDLRecord<IDLDOMString, IDLDouble>::isNullValue(dictionary.parameterData)) {
        auto parameterDataValue = toJS<IDLRecord<IDLDOMString, IDLDouble>>(lexicalGlobalObject, globalObject, throwScope, IDLRecord<IDLDOMString, IDLDouble>::extractValueFromNullable(dictionary.parameterData));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "parameterData"_s), parameterDataValue);
    }
    if (!IDLObject::isNullValue(dictionary.processorOptions)) {
        auto processorOptionsValue = toJS<IDLObject>(lexicalGlobalObject, throwScope, IDLObject::extractValueFromNullable(dictionary.processorOptions));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "processorOptions"_s), processorOptionsValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
