/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioTimestamp.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> AudioTimestamp convertDictionary<AudioTimestamp>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AudioTimestamp result;
    JSValue contextTimeValue;
    if (isNullOrUndefined)
        contextTimeValue = jsUndefined();
    else {
        contextTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "contextTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!contextTimeValue.isUndefined()) {
        result.contextTime = convert<IDLDouble>(lexicalGlobalObject, contextTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue performanceTimeValue;
    if (isNullOrUndefined)
        performanceTimeValue = jsUndefined();
    else {
        performanceTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "performanceTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!performanceTimeValue.isUndefined()) {
        result.performanceTime = convert<IDLDouble>(lexicalGlobalObject, performanceTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const AudioTimestamp& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.contextTime)) {
        auto contextTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.contextTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "contextTime"_s), contextTimeValue);
    }
    if (!IDLDouble::isNullValue(dictionary.performanceTime)) {
        auto performanceTimeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.performanceTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "performanceTime"_s), performanceTimeValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
