#include <wtf/FastMalloc.h>
#include <wtf/Noncopyable.h>

#pragma once

namespace WebCore {
using namespace JSC;

class DOMClientIsoSubspaces {
    WTF_MAKE_NONCOPYABLE(DOMClientIsoSubspaces);
    WTF_MAKE_FAST_ALLOCATED(DOMClientIsoSubspaces);
public:
    DOMClientIsoSubspaces() = default;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInternalSettingsGenerated;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBarcodeDetector;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFaceDetector;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextDetector;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPU;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUAdapter;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUAdapterInfo;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUBindGroup;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUBindGroupLayout;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUBuffer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUBufferUsage;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUColorWrite;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUCommandBuffer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUCommandEncoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUCompilationInfo;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUCompilationMessage;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUComputePassEncoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUComputePipeline;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUDevice;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUDeviceLostInfo;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUExternalTexture;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUInternalError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUMapMode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUOutOfMemoryError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUPipelineError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUPipelineLayout;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUQuerySet;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUQueue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPURenderBundle;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPURenderBundleEncoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPURenderPassEncoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPURenderPipeline;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUSampler;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUShaderModule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUShaderStage;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUSupportedFeatures;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUSupportedLimits;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUTexture;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUTextureUsage;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUTextureView;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUUncapturedErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUValidationError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebKitPlaybackTargetAvailabilityEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForClipboard;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForClipboardItem;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMAudioSession;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMCache;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMCacheStorage;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCompressionStream;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCompressionStreamEncoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDecompressionStream;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDecompressionStreamDecoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForContactsManager;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCookieStore;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBasicCredential;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCredentialsContainer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaKeyMessageEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaKeySession;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaKeyStatusMap;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaKeyStatusMapIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaKeySystemAccess;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaKeys;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebKitMediaKeyMessageEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebKitMediaKeyNeededEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebKitMediaKeySession;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebKitMediaKeys;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMFileSystem;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemDirectoryEntry;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemDirectoryReader;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemEntry;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemFileEntry;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFetchHeaders;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFetchHeadersIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFetchRequest;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFetchResponse;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemDirectoryHandle;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemDirectoryHandleIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemFileHandle;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemHandle;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileSystemSyncAccessHandle;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGamepad;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGamepadButton;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGamepadEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGamepadHapticActuator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGeolocation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGeolocationCoordinates;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGeolocationPosition;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGeolocationPositionError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHighlight;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHighlightRegister;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBCursor;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBCursorWithValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBDatabase;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBFactory;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBIndex;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBKeyRange;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBObjectStore;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBOpenDBRequest;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBRequest;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBTransaction;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIDBVersionChangeEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaCapabilities;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaControlsHost;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBlobEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaRecorder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaRecorderErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaMetadata;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaSession;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaSessionCoordinator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBufferedChangeEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForManagedMediaSource;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForManagedSourceBuffer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaSource;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSourceBuffer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSourceBufferList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVideoPlaybackQuality;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCanvasCaptureMediaStreamTrack;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInputDeviceInfo;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaDeviceInfo;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaDevices;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaStream;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaStreamTrack;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaStreamTrackEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOverconstrainedError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOverconstrainedErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCCertificate;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCDTMFSender;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCDTMFToneChangeEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCDataChannel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCDataChannelEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCDtlsTransport;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCEncodedAudioFrame;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCEncodedVideoFrame;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCIceCandidate;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCIceTransport;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCPeerConnection;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCPeerConnectionIceErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCPeerConnectionIceEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCRtpReceiver;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCRtpSFrameTransform;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCRtpSFrameTransformErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCRtpScriptTransform;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCRtpScriptTransformer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCRtpSender;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCRtpTransceiver;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCSctpTransport;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCSessionDescription;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCStatsReport;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCTrackEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRTCTransformEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLModelElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNotification;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNotificationEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMerchantValidationEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPaymentAddress;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPaymentMethodChangeEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPaymentRequest;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPaymentRequestUpdateEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPaymentResponse;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPermissionStatus;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPermissions;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPictureInPictureEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPictureInPictureWindow;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPushEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPushManager;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPushMessageData;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPushSubscription;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPushSubscriptionChangeEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPushSubscriptionOptions;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRemotePlayback;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeprecationReportBody;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReport;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReportBody;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReportingObserver;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTestReportBody;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWakeLock;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWakeLockSentinel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechRecognition;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechRecognitionAlternative;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechRecognitionErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechRecognitionEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechRecognitionResult;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechRecognitionResultList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechSynthesis;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechSynthesisErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechSynthesisEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechSynthesisUtterance;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSpeechSynthesisVoice;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStorageManager;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForByteLengthQueuingStrategy;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCountQueuingStrategy;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReadableByteStreamController;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReadableStream;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReadableStreamBYOBReader;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReadableStreamBYOBRequest;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReadableStreamDefaultController;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReadableStreamDefaultReader;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReadableStreamSink;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForReadableStreamSource;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTransformStream;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTransformStreamDefaultController;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWritableStream;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWritableStreamDefaultController;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWritableStreamDefaultWriter;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWritableStreamSink;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebLock;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebLockManager;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAnalyserNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioBuffer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioBufferSourceNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioContext;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioDestinationNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioListener;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioParam;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioParamMap;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioProcessingEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioScheduledSourceNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioWorklet;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioWorkletGlobalScope;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioWorkletNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioWorkletProcessor;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBaseAudioContext;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBiquadFilterNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForChannelMergerNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForChannelSplitterNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForConstantSourceNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForConvolverNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDelayNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDynamicsCompressorNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGainNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIIRFilterNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaElementAudioSourceNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaStreamAudioDestinationNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaStreamAudioSourceNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOfflineAudioCompletionEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOfflineAudioContext;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOscillatorNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPannerNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPeriodicWave;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForScriptProcessorNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStereoPannerNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWaveShaperNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAuthenticatorAssertionResponse;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAuthenticatorAttestationResponse;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAuthenticatorResponse;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPublicKeyCredential;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVideoColorSpace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebCodecsEncodedVideoChunk;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebCodecsVideoDecoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebCodecsVideoEncoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebCodecsVideoFrame;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDatabase;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSQLError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSQLResultSet;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSQLResultSetRowList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSQLTransaction;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCloseEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebSocket;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRBoundedReferenceSpace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRFrame;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRHand;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRHandIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRInputSource;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRInputSourceArray;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRInputSourceArrayIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRJointPose;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRJointSpace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRLayer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRPose;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRReferenceSpace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRRenderState;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRRigidTransform;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRSession;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRSpace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRSystem;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRView;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRViewerPose;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRViewport;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebXRWebGLLayer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXRInputSourceEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXRInputSourcesChangeEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXRReferenceSpaceEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXRSessionEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAnimationEffect;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAnimationPlaybackEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAnimationTimeline;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSAnimation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSAnimationEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSTransition;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSTransitionEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCustomEffect;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDocumentTimeline;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForKeyframeEffect;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebAnimation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCryptoKey;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSubtleCrypto;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSConditionRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSContainerRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSCounterStyleRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSFontFaceRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSFontFeatureValuesRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSFontPaletteValuesRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSGroupingRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSImportRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSKeyframeRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSKeyframesRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSLayerBlockRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSLayerStatementRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMediaRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSNamespaceRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSPageRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSPaintSize;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSPropertyRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSRuleList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSStyleDeclaration;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSStyleRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSStyleSheet;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSSupportsRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSUnknownRule;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMCSSNamespace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMMatrix;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMMatrixReadOnly;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeprecatedCSSOMCounter;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeprecatedCSSOMPrimitiveValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeprecatedCSSOMRGBColor;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeprecatedCSSOMRect;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeprecatedCSSOMValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeprecatedCSSOMValueList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFontFace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFontFaceSet;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFontFaceSetIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaQueryList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaQueryListEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStyleMedia;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStyleSheet;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStyleSheetList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSKeywordValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSNumericValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSOMVariableReferenceValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSStyleImageValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSStyleValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSUnitValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSUnparsedValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSUnparsedValueIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStylePropertyMap;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStylePropertyMapReadOnly;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStylePropertyMapReadOnlyIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSColor;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSColorValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSHSL;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSHWB;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSLCH;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSLab;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSOKLCH;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSOKLab;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSRGB;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMathClamp;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMathInvert;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMathMax;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMathMin;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMathNegate;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMathProduct;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMathSum;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMathValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSNumericArray;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSNumericArrayIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSMatrixComponent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSPerspective;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSRotate;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSScale;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSSkew;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSSkewX;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSSkewY;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSTransformComponent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSTransformValue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSTransformValueIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSSTranslate;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAbortController;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAbortSignal;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAbstractRange;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAttr;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBeforeUnloadEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBroadcastChannel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCDATASection;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCharacterData;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForClipboardEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForComment;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCompositionEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCustomElementRegistry;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCustomEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMException;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMImplementation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMPoint;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMPointReadOnly;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMQuad;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMRect;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMRectList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMRectReadOnly;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMStringList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMStringMap;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDataTransfer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDataTransferItem;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDataTransferItemList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeviceMotionEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDeviceOrientationEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDocument;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDocumentFragment;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDocumentType;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDragEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForElementInternals;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForErrorEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEventTarget;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFocusEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFormDataEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHashChangeEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIdleDeadline;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInputEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForKeyboardEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMessageChannel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMessageEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMessagePort;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMouseEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMutationEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMutationObserver;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMutationRecord;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNamedNodeMap;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNodeIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNodeList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNodeListIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOverflowEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPageTransitionEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPointerEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPopStateEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForProcessingInstruction;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForProgressEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPromiseRejectionEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRange;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSecurityPolicyViolationEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForShadowRoot;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStaticRange;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForText;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextDecoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextDecoderStream;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextDecoderStreamDecoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextEncoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextEncoderStream;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextEncoderStreamEncoder;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForToggleEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTouch;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTouchEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTouchList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTreeWalker;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForUIEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWheelEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXMLDocument;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBlob;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFile;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileReader;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFileReaderSync;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMFormData;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMFormDataIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMTokenList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMTokenListIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMURL;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLAllCollection;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLAnchorElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLAreaElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLAttachmentElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLAudioElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLBRElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLBaseElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLBodyElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLButtonElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLCanvasElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLCollection;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLDListElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLDataElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLDataListElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLDetailsElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLDialogElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLDirectoryElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLDivElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLDocument;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLEmbedElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLFieldSetElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLFontElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLFormControlsCollection;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLFormElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLFrameElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLFrameSetElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLHRElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLHeadElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLHeadingElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLHtmlElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLIFrameElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLImageElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLInputElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLLIElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLLabelElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLLegendElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLLinkElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLMapElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLMarqueeElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLMediaElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLMenuElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLMenuItemElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLMetaElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLMeterElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLModElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLOListElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLObjectElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLOptGroupElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLOptionElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLOptionsCollection;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLOutputElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLParagraphElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLParamElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLPictureElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLPreElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLProgressElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLQuoteElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLScriptElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLSelectElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLSlotElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLSourceElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLSpanElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLStyleElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTableCaptionElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTableCellElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTableColElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTableElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTableRowElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTableSectionElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTemplateElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTextAreaElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTimeElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTitleElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLTrackElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLUListElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLUnknownElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHTMLVideoElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForImageBitmap;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForImageData;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaController;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaEncryptedEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMediaError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOffscreenCanvas;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRadioNodeList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSubmitEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextMetrics;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTimeRanges;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForURLSearchParams;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForURLSearchParamsIterator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForUserActivation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForValidityState;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebKitMediaKeyError;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForANGLEInstancedArrays;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCanvasGradient;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCanvasPattern;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCanvasRenderingContext2D;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTBlendMinMax;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTClipControl;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTColorBufferFloat;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTColorBufferHalfFloat;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTConservativeDepth;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTDepthClamp;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTDisjointTimerQuery;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTDisjointTimerQueryWebGL2;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTFloatBlend;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTFragDepth;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTPolygonOffsetClamp;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTRenderSnorm;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTShaderTextureLOD;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTTextureCompressionBPTC;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTTextureCompressionRGTC;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTTextureFilterAnisotropic;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTTextureMirrorClampToEdge;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTTextureNorm16;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEXTsRGB;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGPUCanvasContext;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForImageBitmapRenderingContext;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForKHRParallelShaderCompile;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNVShaderNoperspectiveInterpolation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESDrawBuffersIndexed;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESElementIndexUint;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESFBORenderMipmap;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESSampleVariables;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESShaderMultisampleInterpolation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESStandardDerivatives;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESTextureFloat;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESTextureFloatLinear;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESTextureHalfFloat;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESTextureHalfFloatLinear;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOESVertexArrayObject;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForOffscreenCanvasRenderingContext2D;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPaintRenderingContext2D;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPath2D;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGL2RenderingContext;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLActiveInfo;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLBuffer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLClipCullDistance;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLColorBufferFloat;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLCompressedTextureASTC;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLCompressedTextureETC;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLCompressedTextureETC1;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLCompressedTexturePVRTC;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLCompressedTextureS3TC;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLCompressedTextureS3TCsRGB;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLContextEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLDebugRendererInfo;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLDebugShaders;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLDepthTexture;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLDrawBuffers;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLDrawInstancedBaseVertexBaseInstance;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLFramebuffer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLLoseContext;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLMultiDraw;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLMultiDrawInstancedBaseVertexBaseInstance;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLPolygonMode;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLProgram;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLProvokingVertex;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLQuery;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLRenderSharedExponent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLRenderbuffer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLRenderingContext;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLSampler;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLShader;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLShaderPrecisionFormat;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLStencilTexturing;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLSync;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLTexture;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLTimerQueryEXT;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLTransformFeedback;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLUniformLocation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLVertexArrayObject;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebGLVertexArrayObjectOES;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioTrack;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioTrackConfiguration;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForAudioTrackList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDataCue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextTrack;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextTrackCue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextTrackCueGeneric;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextTrackCueList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTextTrackList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTrackEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVTTCue;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVTTRegion;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVTTRegionList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVideoTrack;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVideoTrackConfiguration;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVideoTrackList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCommandLineAPIHost;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInspectorAuditAccessibilityObject;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInspectorAuditDOMObject;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInspectorAuditResourcesObject;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInspectorFrontendHost;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCOEPInheritenceViolationReportBody;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCORPViolationReportBody;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMApplicationCache;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMathMLElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMathMLMathElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBarProp;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCrypto;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMSelection;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForEventSource;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForHistory;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIntersectionObserver;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForIntersectionObserverEntry;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForLocalDOMWindow;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForLocation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNavigator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformance;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceEntry;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceMark;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceMeasure;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceNavigation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceNavigationTiming;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceObserver;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceObserverEntryList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformancePaintTiming;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceResourceTiming;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceServerTiming;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPerformanceTiming;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForRemoteDOMWindow;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForResizeObserver;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForResizeObserverEntry;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForResizeObserverSize;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForScreen;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForScreenOrientation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForShadowRealmGlobalScope;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForUndoItem;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForUndoManager;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForUserMessageHandler;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForUserMessageHandlersNamespace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForVisualViewport;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebKitNamespace;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWebKitPoint;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWorkerNavigator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForCSPViolationReportBody;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMMimeType;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMMimeTypeArray;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMPlugin;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMPluginArray;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStorage;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForStorageEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAngle;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimateColorElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimateElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimateMotionElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimateTransformElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedAngle;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedBoolean;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedEnumeration;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedInteger;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedLength;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedLengthList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedNumber;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedNumberList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedPreserveAspectRatio;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedRect;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedString;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimatedTransformList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGAnimationElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGCircleElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGClipPathElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGComponentTransferFunctionElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGDefsElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGDescElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGEllipseElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEBlendElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEColorMatrixElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEComponentTransferElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFECompositeElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEConvolveMatrixElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEDiffuseLightingElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEDisplacementMapElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEDistantLightElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEDropShadowElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEFloodElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEFuncAElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEFuncBElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEFuncGElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEFuncRElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEGaussianBlurElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEImageElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEMergeElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEMergeNodeElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEMorphologyElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEOffsetElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFEPointLightElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFESpecularLightingElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFESpotLightElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFETileElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFETurbulenceElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGFilterElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGForeignObjectElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGGElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGGeometryElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGGradientElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGGraphicsElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGImageElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGLength;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGLengthList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGLineElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGLinearGradientElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGMPathElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGMarkerElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGMaskElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGMatrix;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGMetadataElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGNumber;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGNumberList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSeg;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegArcAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegArcRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegClosePath;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegCurvetoCubicAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegCurvetoCubicRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegCurvetoCubicSmoothAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegCurvetoCubicSmoothRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegCurvetoQuadraticAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegCurvetoQuadraticRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegCurvetoQuadraticSmoothAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegCurvetoQuadraticSmoothRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegLinetoAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegLinetoHorizontalAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegLinetoHorizontalRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegLinetoRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegLinetoVerticalAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegLinetoVerticalRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegMovetoAbs;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPathSegMovetoRel;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPatternElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPoint;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPointList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPolygonElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPolylineElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGPreserveAspectRatio;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGRadialGradientElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGRect;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGRectElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGRenderingIntent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGSVGElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGScriptElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGSetElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGStopElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGStringList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGStyleElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGSwitchElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGSymbolElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGTSpanElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGTextContentElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGTextElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGTextPathElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGTextPositioningElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGTitleElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGTransform;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGTransformList;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGUnitTypes;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGUseElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGViewElement;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSVGViewSpec;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForGCObservation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInternalSettings;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInternals;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInternalsMapLike;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForInternalsSetLike;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMallocStatistics;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMemoryInfo;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMockCDMFactory;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMockContentFilterSettings;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForMockPageOverlay;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForServiceWorkerInternals;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForTypeConversions;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDedicatedWorkerGlobalScope;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWorker;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWorkerGlobalScope;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWorkerLocation;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForExtendableEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForExtendableMessageEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForFetchEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForNavigationPreloadManager;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForServiceWorker;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForServiceWorkerClient;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForServiceWorkerClients;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForServiceWorkerContainer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForServiceWorkerGlobalScope;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForServiceWorkerRegistration;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForServiceWorkerWindowClient;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBackgroundFetchEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBackgroundFetchManager;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBackgroundFetchRecord;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBackgroundFetchRegistration;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForBackgroundFetchUpdateUIEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSharedWorker;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForSharedWorkerGlobalScope;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForPaintWorkletGlobalScope;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWorklet;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForWorkletGlobalScope;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForDOMParser;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXMLHttpRequest;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXMLHttpRequestEventTarget;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXMLHttpRequestProgressEvent;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXMLHttpRequestUpload;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXMLSerializer;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXPathEvaluator;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXPathExpression;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXPathNSResolver;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXPathResult;
    std::unique_ptr<GCClient::IsoSubspace> m_clientSubspaceForXSLTProcessor;
};
} // namespace WebCore
