/*
 * Copyright (C) 2021-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "ArgumentCoders.h"
#include "Connection.h"
#include "MessageNames.h"
#include <wtf/Forward.h>
#include <wtf/ThreadSafeRefCounted.h>

namespace WebCore {
class FloatPoint;
class FloatRect;
}

namespace Messages {
namespace ViewGestureController {

static inline IPC::ReceiverName messageReceiverName()
{
    return IPC::ReceiverName::ViewGestureController;
}

#if PLATFORM(MAC)
class DidCollectGeometryForSmartMagnificationGesture {
public:
    using Arguments = std::tuple<WebCore::FloatPoint, WebCore::FloatRect, WebCore::FloatRect, bool, double, double>;

    static IPC::MessageName name() { return IPC::MessageName::ViewGestureController_DidCollectGeometryForSmartMagnificationGesture; }
    static constexpr bool isSync = false;

    DidCollectGeometryForSmartMagnificationGesture(const WebCore::FloatPoint& origin, const WebCore::FloatRect& renderRect, const WebCore::FloatRect& visibleContentBounds, bool fitEntireRect, double viewportMinimumScale, double viewportMaximumScale)
        : m_arguments(origin, renderRect, visibleContentBounds, fitEntireRect, viewportMinimumScale, viewportMaximumScale)
    {
    }

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<const WebCore::FloatPoint&, const WebCore::FloatRect&, const WebCore::FloatRect&, bool, double, double> m_arguments;
};
#endif

#if !PLATFORM(IOS_FAMILY)
class DidCollectGeometryForMagnificationGesture {
public:
    using Arguments = std::tuple<WebCore::FloatRect, bool>;

    static IPC::MessageName name() { return IPC::MessageName::ViewGestureController_DidCollectGeometryForMagnificationGesture; }
    static constexpr bool isSync = false;

    DidCollectGeometryForMagnificationGesture(const WebCore::FloatRect& visibleContentBounds, bool frameHandlesMagnificationGesture)
        : m_arguments(visibleContentBounds, frameHandlesMagnificationGesture)
    {
    }

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<const WebCore::FloatRect&, bool> m_arguments;
};
#endif

#if !PLATFORM(IOS_FAMILY)
class DidHitRenderTreeSizeThreshold {
public:
    using Arguments = std::tuple<>;

    static IPC::MessageName name() { return IPC::MessageName::ViewGestureController_DidHitRenderTreeSizeThreshold; }
    static constexpr bool isSync = false;

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<> m_arguments;
};
#endif

} // namespace ViewGestureController
} // namespace Messages
