/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import ucar.nc2.Variable;
import ucar.nc2.write.Nc4ChunkingDefault;

public class Nc4ChunkingStrategyGrib
extends Nc4ChunkingDefault {
    public Nc4ChunkingStrategyGrib(int deflateLevel, boolean shuffle) {
        super(deflateLevel, shuffle);
    }

    @Override
    public boolean isChunked(Variable v) {
        if (v.isUnlimited()) {
            return true;
        }
        if (this.getChunkAttribute(v) != null) {
            return true;
        }
        int n = v.getRank();
        return n >= 2 && v.getSize() * (long)v.getElementSize() > (long)this.getMinVariableSize();
    }

    @Override
    public long[] computeChunking(Variable v) {
        long varSize;
        int[] resultFromAtt = this.computeChunkingFromAttribute(v);
        if (resultFromAtt != null) {
            return this.convertToLong(resultFromAtt);
        }
        if (!v.isUnlimited()) {
            int[] result = this.computeChunkingGrib(v);
            return this.convertToLong(result);
        }
        if (v.getRank() >= 2 && (varSize = v.getSize() * (long)v.getElementSize()) > (long)this.getMinVariableSize()) {
            return this.convertToLong(this.computeChunkingGrib(v));
        }
        int[] result = this.computeUnlimitedChunking(v.getDimensions(), v.getElementSize());
        return this.convertToLong(result);
    }

    private int[] computeChunkingGrib(Variable v) {
        int n = v.getRank();
        int[] result = new int[n];
        if (n < 2) {
            result[0] = 1;
        } else {
            for (int i = 0; i < n; ++i) {
                result[i] = i < n - 2 ? 1 : v.getDimension(i).getLength();
            }
        }
        return result;
    }
}

