/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.vector;

import org.apache.solr.util.vector.DenseVectorParser;

public class FloatDenseVectorParser
extends DenseVectorParser {
    private float[] vector;
    private int curPosition;

    public FloatDenseVectorParser(int dimension, Object inputValue, DenseVectorParser.BuilderPhase builderPhase) {
        this.dimension = dimension;
        this.inputValue = inputValue;
        this.curPosition = 0;
        this.builderPhase = builderPhase;
    }

    @Override
    public float[] getFloatVector() {
        if (this.vector == null) {
            this.vector = new float[this.dimension];
            this.parseVector();
        }
        return this.vector;
    }

    @Override
    protected void addNumberElement(Number element) {
        this.vector[this.curPosition++] = element.floatValue();
    }

    @Override
    protected void addStringElement(String element) {
        this.vector[this.curPosition++] = Float.parseFloat(element);
    }

    @Override
    protected String errorMessage() {
        return "The expected format is:'[f1,f2..f3]' where each element f is a float";
    }
}

