/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.client.api.endpoint.ClusterPropertyApis;
import org.apache.solr.client.api.model.ClusterPropertyDetails;
import org.apache.solr.client.api.model.GetClusterPropertyResponse;
import org.apache.solr.client.api.model.ListClusterPropertiesResponse;
import org.apache.solr.client.api.model.SetClusterPropertyRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class ClusterProperty
extends AdminAPIBase
implements ClusterPropertyApis {
    protected final ClusterProperties clusterProperties = new ClusterProperties(this.fetchAndValidateZooKeeperAwareCoreContainer().getZkController().getZkClient());

    @Inject
    public ClusterProperty(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public ListClusterPropertiesResponse listClusterProperties() {
        ListClusterPropertiesResponse response = this.instantiateJerseyResponse(ListClusterPropertiesResponse.class);
        try {
            response.clusterProperties = new ArrayList(this.clusterProperties.getClusterProperties().keySet());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    public SolrJerseyResponse getClusterProperty(String propertyName) {
        GetClusterPropertyResponse response = this.instantiateJerseyResponse(GetClusterPropertyResponse.class);
        try {
            Object value = this.clusterProperties.getClusterProperties().get(propertyName);
            if (value == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such cluster property [" + propertyName + "]");
            }
            response.clusterProperty = new ClusterPropertyDetails();
            response.clusterProperty.name = propertyName;
            response.clusterProperty.value = value;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createOrUpdateClusterProperty(String propertyName, SetClusterPropertyRequestBody requestBody) throws IOException {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.clusterProperties.setClusterProperty(propertyName, (Object)requestBody.value);
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createOrUpdateNestedClusterProperty(Map<String, Object> propertyValuesByName) {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        try {
            this.clusterProperties.setClusterProperties(propertyValuesByName);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in API", (Throwable)e);
        }
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse deleteClusterProperty(String propertyName) {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        try {
            this.clusterProperties.setClusterProperty(propertyName, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}

