/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.ermodel.model.DatabaseObjectBacked;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;

abstract class AbstractDatabaseObjectBacked<DO extends DatabaseObject>
implements DatabaseObjectBacked<DO> {
    private static final long serialVersionUID = -1252099222675350939L;
    private final DO dbObject;

    public AbstractDatabaseObjectBacked(DO dbObject) {
        this.dbObject = (DatabaseObject)Objects.requireNonNull(dbObject, "No database object provided");
    }

    @Override
    public int compareTo(NamedObject namedObj) {
        if (namedObj == null) {
            return 1;
        }
        return this.key().compareTo(namedObj.key());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamedObject) {
            NamedObject namedObj = (NamedObject)obj;
            return this.key().equals(namedObj.key());
        }
        return false;
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.dbObject.getAttribute(name);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) throws ClassCastException {
        return this.dbObject.getAttribute(name, defaultValue);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.dbObject.getAttributes();
    }

    @Override
    public DO getDatabaseObject() {
        return this.dbObject;
    }

    @Override
    public String getFullName() {
        return this.dbObject.getFullName();
    }

    @Override
    public String getName() {
        return this.dbObject.getName();
    }

    @Override
    public String getRemarks() {
        return this.dbObject.getRemarks();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.dbObject.hasAttribute(name);
    }

    public int hashCode() {
        return this.key().hashCode();
    }

    @Override
    public boolean hasRemarks() {
        return this.dbObject.hasRemarks();
    }

    @Override
    public NamedObjectKey key() {
        return this.dbObject.key();
    }

    @Override
    public <T> Optional<T> lookupAttribute(String name) {
        return this.dbObject.lookupAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.dbObject.removeAttribute(name);
    }

    @Override
    public <T> void setAttribute(String name, T value) {
        this.dbObject.setAttribute(name, value);
    }

    @Override
    public void setRemarks(String remarks) {
        this.dbObject.setRemarks(remarks);
    }

    public String toString() {
        return this.dbObject.toString();
    }
}

