/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.module;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.module.CreateImportMetaNode;
import com.oracle.truffle.js.nodes.module.ImportMetaNodeGen;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.Set;

public abstract class ImportMetaNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    JavaScriptNode moduleNode;

    ImportMetaNode(JavaScriptNode moduleNode) {
        this.moduleNode = moduleNode;
    }

    @NeverDefault
    public static JavaScriptNode create(JavaScriptNode moduleNode) {
        return ImportMetaNodeGen.create(moduleNode);
    }

    @Specialization(guards={"importMeta != null"})
    protected static JSObject getImportMeta(JSModuleRecord module, @Bind(value="module.getImportMetaOrNull()") JSObject importMeta) {
        return importMeta;
    }

    @Fallback
    protected static JSObject createImportMeta(Object module, @Cached CreateImportMetaNode createImportMetaNode) {
        return ((JSModuleRecord)module).getImportMeta(createImportMetaNode);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ImportMetaNode.create(ImportMetaNode.cloneUninitialized(this.moduleNode, materializedTags));
    }
}

